package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  SharedLabel,
  IdType,
  ResourceNameType,
  TimestampType,
  HashType,
  SizeType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class FolderMetadata(
    id: Option[ResourceIdType] = None,
    name: Option[ResourceNameType] = None,
    creatorId: Option[IdType] = None,
    parentFolderId: Option[ResourceIdType] = None,
    createdTimestamp: Option[TimestampType] = None,
    modifiedTimestamp: Option[TimestampType] = None,
    resourceState: Option[zio.aws.workdocs.model.ResourceStateType] = None,
    signature: Option[HashType] = None,
    labels: Option[Iterable[SharedLabel]] = None,
    size: Option[SizeType] = None,
    latestVersionSize: Option[SizeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.FolderMetadata = {
    import FolderMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.FolderMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creatorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.creatorId)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .optionallyWith(
        signature.map(value => HashType.unwrap(value): java.lang.String)
      )(_.signature)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SharedLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        size.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.size)
      .optionallyWith(
        latestVersionSize.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.latestVersionSize)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.FolderMetadata.ReadOnly =
    zio.aws.workdocs.model.FolderMetadata.wrap(buildAwsValue())
}
object FolderMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.FolderMetadata =
      zio.aws.workdocs.model.FolderMetadata(
        id.map(value => value),
        name.map(value => value),
        creatorId.map(value => value),
        parentFolderId.map(value => value),
        createdTimestamp.map(value => value),
        modifiedTimestamp.map(value => value),
        resourceState.map(value => value),
        signature.map(value => value),
        labels.map(value => value),
        size.map(value => value),
        latestVersionSize.map(value => value)
      )
    def id: Option[ResourceIdType]
    def name: Option[ResourceNameType]
    def creatorId: Option[IdType]
    def parentFolderId: Option[ResourceIdType]
    def createdTimestamp: Option[TimestampType]
    def modifiedTimestamp: Option[TimestampType]
    def resourceState: Option[zio.aws.workdocs.model.ResourceStateType]
    def signature: Option[HashType]
    def labels: Option[List[SharedLabel]]
    def size: Option[SizeType]
    def latestVersionSize: Option[SizeType]
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getCreatorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
    def getSignature: ZIO[Any, AwsError, HashType] =
      AwsError.unwrapOptionField("signature", signature)
    def getLabels: ZIO[Any, AwsError, List[SharedLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getSize: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("size", size)
    def getLatestVersionSize: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("latestVersionSize", latestVersionSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ) extends zio.aws.workdocs.model.FolderMetadata.ReadOnly {
    override val id: Option[ResourceIdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val creatorId: Option[IdType] = scala
      .Option(impl.creatorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val parentFolderId: Option[ResourceIdType] = scala
      .Option(impl.parentFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.modifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val resourceState
        : Option[zio.aws.workdocs.model.ResourceStateType] = scala
      .Option(impl.resourceState())
      .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
    override val signature: Option[HashType] = scala
      .Option(impl.signature())
      .map(value => zio.aws.workdocs.model.primitives.HashType(value))
    override val labels: Option[List[SharedLabel]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SharedLabel(item)
        }.toList
      )
    override val size: Option[SizeType] = scala
      .Option(impl.size())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val latestVersionSize: Option[SizeType] = scala
      .Option(impl.latestVersionSize())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ): zio.aws.workdocs.model.FolderMetadata.ReadOnly = new Wrapper(impl)
}
