package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  SearchQueryType,
  IdType,
  UserIdsType,
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DescribeUsersRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    organizationId: Option[IdType] = None,
    userIds: Option[UserIdsType] = None,
    query: Option[SearchQueryType] = None,
    include: Option[zio.aws.workdocs.model.UserFilterType] = None,
    order: Option[zio.aws.workdocs.model.OrderType] = None,
    sort: Option[zio.aws.workdocs.model.UserSortType] = None,
    marker: Option[PageMarkerType] = None,
    limit: Option[LimitType] = None,
    fields: Option[FieldNamesType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        userIds.map(value => UserIdsType.unwrap(value): java.lang.String)
      )(_.userIds)
      .optionallyWith(
        query.map(value => SearchQueryType.unwrap(value): java.lang.String)
      )(_.query)
      .optionallyWith(include.map(value => value.unwrap))(_.include)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeUsersRequest.wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeUsersRequest =
      zio.aws.workdocs.model.DescribeUsersRequest(
        authenticationToken.map(value => value),
        organizationId.map(value => value),
        userIds.map(value => value),
        query.map(value => value),
        include.map(value => value),
        order.map(value => value),
        sort.map(value => value),
        marker.map(value => value),
        limit.map(value => value),
        fields.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def organizationId: Option[IdType]
    def userIds: Option[UserIdsType]
    def query: Option[SearchQueryType]
    def include: Option[zio.aws.workdocs.model.UserFilterType]
    def order: Option[zio.aws.workdocs.model.OrderType]
    def sort: Option[zio.aws.workdocs.model.UserSortType]
    def marker: Option[PageMarkerType]
    def limit: Option[LimitType]
    def fields: Option[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getUserIds: ZIO[Any, AwsError, UserIdsType] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getQuery: ZIO[Any, AwsError, SearchQueryType] =
      AwsError.unwrapOptionField("query", query)
    def getInclude: ZIO[Any, AwsError, zio.aws.workdocs.model.UserFilterType] =
      AwsError.unwrapOptionField("include", include)
    def getOrder: ZIO[Any, AwsError, zio.aws.workdocs.model.OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getSort: ZIO[Any, AwsError, zio.aws.workdocs.model.UserSortType] =
      AwsError.unwrapOptionField("sort", sort)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ) extends zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val userIds: Option[UserIdsType] = scala
      .Option(impl.userIds())
      .map(value => zio.aws.workdocs.model.primitives.UserIdsType(value))
    override val query: Option[SearchQueryType] = scala
      .Option(impl.query())
      .map(value => zio.aws.workdocs.model.primitives.SearchQueryType(value))
    override val include: Option[zio.aws.workdocs.model.UserFilterType] = scala
      .Option(impl.include())
      .map(value => zio.aws.workdocs.model.UserFilterType.wrap(value))
    override val order: Option[zio.aws.workdocs.model.OrderType] = scala
      .Option(impl.order())
      .map(value => zio.aws.workdocs.model.OrderType.wrap(value))
    override val sort: Option[zio.aws.workdocs.model.UserSortType] = scala
      .Option(impl.sort())
      .map(value => zio.aws.workdocs.model.UserSortType.wrap(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val fields: Option[FieldNamesType] = scala
      .Option(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ): zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly = new Wrapper(impl)
}
