package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DescribeRootFoldersRequest(
    authenticationToken: AuthenticationHeaderType,
    limit: Option[LimitType] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest = {
    import DescribeRootFoldersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
      .builder()
      .authenticationToken(
        AuthenticationHeaderType.unwrap(authenticationToken): java.lang.String
      )
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeRootFoldersRequest.wrap(buildAwsValue())
}
object DescribeRootFoldersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeRootFoldersRequest =
      zio.aws.workdocs.model.DescribeRootFoldersRequest(
        authenticationToken,
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: AuthenticationHeaderType
    def limit: Option[LimitType]
    def marker: Option[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, Nothing, AuthenticationHeaderType] =
      ZIO.succeed(authenticationToken)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ) extends zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly {
    override val authenticationToken: AuthenticationHeaderType =
      zio.aws.workdocs.model.primitives
        .AuthenticationHeaderType(impl.authenticationToken())
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ): zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly = new Wrapper(
    impl
  )
}
