package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  IdType,
  TimestampType,
  CommentTextType,
  CommentIdType
}
import scala.jdk.CollectionConverters.*
final case class Comment(
    commentId: CommentIdType,
    parentId: Option[CommentIdType] = None,
    threadId: Option[CommentIdType] = None,
    text: Option[CommentTextType] = None,
    contributor: Option[zio.aws.workdocs.model.User] = None,
    createdTimestamp: Option[TimestampType] = None,
    status: Option[zio.aws.workdocs.model.CommentStatusType] = None,
    visibility: Option[zio.aws.workdocs.model.CommentVisibilityType] = None,
    recipientId: Option[IdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Comment = {
    import Comment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Comment
      .builder()
      .commentId(CommentIdType.unwrap(commentId): java.lang.String)
      .optionallyWith(
        parentId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        threadId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.threadId)
      .optionallyWith(
        text.map(value => CommentTextType.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(contributor.map(value => value.buildAwsValue()))(
        _.contributor
      )
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        recipientId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.recipientId)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Comment.ReadOnly =
    zio.aws.workdocs.model.Comment.wrap(buildAwsValue())
}
object Comment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.Comment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Comment =
      zio.aws.workdocs.model.Comment(
        commentId,
        parentId.map(value => value),
        threadId.map(value => value),
        text.map(value => value),
        contributor.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        status.map(value => value),
        visibility.map(value => value),
        recipientId.map(value => value)
      )
    def commentId: CommentIdType
    def parentId: Option[CommentIdType]
    def threadId: Option[CommentIdType]
    def text: Option[CommentTextType]
    def contributor: Option[zio.aws.workdocs.model.User.ReadOnly]
    def createdTimestamp: Option[TimestampType]
    def status: Option[zio.aws.workdocs.model.CommentStatusType]
    def visibility: Option[zio.aws.workdocs.model.CommentVisibilityType]
    def recipientId: Option[IdType]
    def getCommentId: ZIO[Any, Nothing, CommentIdType] = ZIO.succeed(commentId)
    def getParentId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getThreadId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("threadId", threadId)
    def getText: ZIO[Any, AwsError, CommentTextType] =
      AwsError.unwrapOptionField("text", text)
    def getContributor
        : ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("contributor", contributor)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentVisibilityType] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getRecipientId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("recipientId", recipientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Comment
  ) extends zio.aws.workdocs.model.Comment.ReadOnly {
    override val commentId: CommentIdType =
      zio.aws.workdocs.model.primitives.CommentIdType(impl.commentId())
    override val parentId: Option[CommentIdType] = scala
      .Option(impl.parentId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val threadId: Option[CommentIdType] = scala
      .Option(impl.threadId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val text: Option[CommentTextType] = scala
      .Option(impl.text())
      .map(value => zio.aws.workdocs.model.primitives.CommentTextType(value))
    override val contributor: Option[zio.aws.workdocs.model.User.ReadOnly] =
      scala
        .Option(impl.contributor())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val status: Option[zio.aws.workdocs.model.CommentStatusType] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.workdocs.model.CommentStatusType.wrap(value))
    override val visibility
        : Option[zio.aws.workdocs.model.CommentVisibilityType] = scala
      .Option(impl.visibility())
      .map(value => zio.aws.workdocs.model.CommentVisibilityType.wrap(value))
    override val recipientId: Option[IdType] = scala
      .Option(impl.recipientId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Comment
  ): zio.aws.workdocs.model.Comment.ReadOnly = new Wrapper(impl)
}
