package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  IdType,
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class GetFolderPathRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    folderId: IdType,
    limit: Option[LimitType] = None,
    fields: Option[FieldNamesType] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest = {
    import GetFolderPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(IdType.unwrap(folderId): java.lang.String)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetFolderPathRequest.ReadOnly =
    zio.aws.workdocs.model.GetFolderPathRequest.wrap(buildAwsValue())
}
object GetFolderPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetFolderPathRequest =
      zio.aws.workdocs.model.GetFolderPathRequest(
        authenticationToken.map(value => value),
        folderId,
        limit.map(value => value),
        fields.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def folderId: IdType
    def limit: Option[LimitType]
    def fields: Option[FieldNamesType]
    def marker: Option[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, IdType] = ZIO.succeed(folderId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest
  ) extends zio.aws.workdocs.model.GetFolderPathRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val folderId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.folderId())
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val fields: Option[FieldNamesType] = scala
      .Option(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest
  ): zio.aws.workdocs.model.GetFolderPathRequest.ReadOnly = new Wrapper(impl)
}
