package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{AuthenticationHeaderType, IdType}
import scala.jdk.CollectionConverters.*
final case class DeactivateUserRequest(
    userId: IdType,
    authenticationToken: Option[AuthenticationHeaderType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest = {
    import DeactivateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest
      .builder()
      .userId(IdType.unwrap(userId): java.lang.String)
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeactivateUserRequest.ReadOnly =
    zio.aws.workdocs.model.DeactivateUserRequest.wrap(buildAwsValue())
}
object DeactivateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeactivateUserRequest =
      zio.aws.workdocs.model
        .DeactivateUserRequest(userId, authenticationToken.map(value => value))
    def userId: IdType
    def authenticationToken: Option[AuthenticationHeaderType]
    def getUserId: ZIO[Any, Nothing, IdType] = ZIO.succeed(userId)
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest
  ) extends zio.aws.workdocs.model.DeactivateUserRequest.ReadOnly {
    override val userId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.userId())
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest
  ): zio.aws.workdocs.model.DeactivateUserRequest.ReadOnly = new Wrapper(impl)
}
