package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  FieldNamesType,
  DocumentVersionIdType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class GetDocumentVersionRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    fields: Option[FieldNamesType] = None,
    includeCustomMetadata: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest = {
    import GetDocumentVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .optionallyWith(
        includeCustomMetadata.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeCustomMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly =
    zio.aws.workdocs.model.GetDocumentVersionRequest.wrap(buildAwsValue())
}
object GetDocumentVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentVersionRequest =
      zio.aws.workdocs.model.GetDocumentVersionRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        fields.map(value => value),
        includeCustomMetadata.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def fields: Option[FieldNamesType]
    def includeCustomMetadata: Option[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
    def getIncludeCustomMetadata: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("includeCustomMetadata", includeCustomMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ) extends zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val fields: Option[FieldNamesType] = scala
      .Option(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val includeCustomMetadata: Option[BooleanType] = scala
      .Option(impl.includeCustomMetadata())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ): zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
