package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentVersionsRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    marker: Option[PageMarkerType] = None,
    limit: Option[LimitType] = None,
    include: Option[FieldNamesType] = None,
    fields: Option[FieldNamesType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest = {
    import DescribeDocumentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        include.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.include)
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeDocumentVersionsRequest.wrap(buildAwsValue())
}
object DescribeDocumentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeDocumentVersionsRequest =
      zio.aws.workdocs.model.DescribeDocumentVersionsRequest(
        authenticationToken.map(value => value),
        documentId,
        marker.map(value => value),
        limit.map(value => value),
        include.map(value => value),
        fields.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def marker: Option[PageMarkerType]
    def limit: Option[LimitType]
    def include: Option[FieldNamesType]
    def fields: Option[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getInclude: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("include", include)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ) extends zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val include: Option[FieldNamesType] = scala
      .Option(impl.include())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val fields: Option[FieldNamesType] = scala
      .Option(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ): zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
