package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{SearchAncestorId, SearchLabel}
import scala.jdk.CollectionConverters._
final case class Filters(
    textLocales: Optional[Iterable[zio.aws.workdocs.model.LanguageCodeType]] =
      Optional.Absent,
    contentCategories: Optional[
      Iterable[zio.aws.workdocs.model.ContentCategoryType]
    ] = Optional.Absent,
    resourceTypes: Optional[
      Iterable[zio.aws.workdocs.model.SearchResourceType]
    ] = Optional.Absent,
    labels: Optional[Iterable[SearchLabel]] = Optional.Absent,
    principals: Optional[Iterable[zio.aws.workdocs.model.SearchPrincipalType]] =
      Optional.Absent,
    ancestorIds: Optional[Iterable[SearchAncestorId]] = Optional.Absent,
    searchCollectionTypes: Optional[
      Iterable[zio.aws.workdocs.model.SearchCollectionType]
    ] = Optional.Absent,
    sizeRange: Optional[zio.aws.workdocs.model.LongRangeType] = Optional.Absent,
    createdRange: Optional[zio.aws.workdocs.model.DateRangeType] =
      Optional.Absent,
    modifiedRange: Optional[zio.aws.workdocs.model.DateRangeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Filters = {
    import Filters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Filters
      .builder()
      .optionallyWith(
        textLocales.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.textLocalesWithStrings)
      .optionallyWith(
        contentCategories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contentCategoriesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SearchLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        ancestorIds.map(value =>
          value.map { item =>
            SearchAncestorId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ancestorIds)
      .optionallyWith(
        searchCollectionTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.searchCollectionTypesWithStrings)
      .optionallyWith(sizeRange.map(value => value.buildAwsValue()))(
        _.sizeRange
      )
      .optionallyWith(createdRange.map(value => value.buildAwsValue()))(
        _.createdRange
      )
      .optionallyWith(modifiedRange.map(value => value.buildAwsValue()))(
        _.modifiedRange
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Filters.ReadOnly =
    zio.aws.workdocs.model.Filters.wrap(buildAwsValue())
}
object Filters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.Filters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Filters =
      zio.aws.workdocs.model.Filters(
        textLocales.map(value => value),
        contentCategories.map(value => value),
        resourceTypes.map(value => value),
        labels.map(value => value),
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ancestorIds.map(value => value),
        searchCollectionTypes.map(value => value),
        sizeRange.map(value => value.asEditable),
        createdRange.map(value => value.asEditable),
        modifiedRange.map(value => value.asEditable)
      )
    def textLocales: Optional[List[zio.aws.workdocs.model.LanguageCodeType]]
    def contentCategories
        : Optional[List[zio.aws.workdocs.model.ContentCategoryType]]
    def resourceTypes: Optional[List[zio.aws.workdocs.model.SearchResourceType]]
    def labels: Optional[List[SearchLabel]]
    def principals
        : Optional[List[zio.aws.workdocs.model.SearchPrincipalType.ReadOnly]]
    def ancestorIds: Optional[List[SearchAncestorId]]
    def searchCollectionTypes
        : Optional[List[zio.aws.workdocs.model.SearchCollectionType]]
    def sizeRange: Optional[zio.aws.workdocs.model.LongRangeType.ReadOnly]
    def createdRange: Optional[zio.aws.workdocs.model.DateRangeType.ReadOnly]
    def modifiedRange: Optional[zio.aws.workdocs.model.DateRangeType.ReadOnly]
    def getTextLocales
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.LanguageCodeType]] =
      AwsError.unwrapOptionField("textLocales", textLocales)
    def getContentCategories
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.ContentCategoryType]] =
      AwsError.unwrapOptionField("contentCategories", contentCategories)
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.SearchResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getLabels: ZIO[Any, AwsError, List[SearchLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getPrincipals: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.SearchPrincipalType.ReadOnly
    ]] = AwsError.unwrapOptionField("principals", principals)
    def getAncestorIds: ZIO[Any, AwsError, List[SearchAncestorId]] =
      AwsError.unwrapOptionField("ancestorIds", ancestorIds)
    def getSearchCollectionTypes: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.SearchCollectionType
    ]] =
      AwsError.unwrapOptionField("searchCollectionTypes", searchCollectionTypes)
    def getSizeRange
        : ZIO[Any, AwsError, zio.aws.workdocs.model.LongRangeType.ReadOnly] =
      AwsError.unwrapOptionField("sizeRange", sizeRange)
    def getCreatedRange
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DateRangeType.ReadOnly] =
      AwsError.unwrapOptionField("createdRange", createdRange)
    def getModifiedRange
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DateRangeType.ReadOnly] =
      AwsError.unwrapOptionField("modifiedRange", modifiedRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Filters
  ) extends zio.aws.workdocs.model.Filters.ReadOnly {
    override val textLocales
        : Optional[List[zio.aws.workdocs.model.LanguageCodeType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textLocales())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.LanguageCodeType.wrap(item)
          }.toList
        )
    override val contentCategories
        : Optional[List[zio.aws.workdocs.model.ContentCategoryType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.ContentCategoryType.wrap(item)
          }.toList
        )
    override val resourceTypes
        : Optional[List[zio.aws.workdocs.model.SearchResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.SearchResourceType.wrap(item)
          }.toList
        )
    override val labels: Optional[List[SearchLabel]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SearchLabel(item)
        }.toList
      )
    override val principals
        : Optional[List[zio.aws.workdocs.model.SearchPrincipalType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.SearchPrincipalType.wrap(item)
          }.toList
        )
    override val ancestorIds: Optional[List[SearchAncestorId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ancestorIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.primitives.SearchAncestorId(item)
          }.toList
        )
    override val searchCollectionTypes
        : Optional[List[zio.aws.workdocs.model.SearchCollectionType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchCollectionTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.SearchCollectionType.wrap(item)
          }.toList
        )
    override val sizeRange
        : Optional[zio.aws.workdocs.model.LongRangeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeRange())
        .map(value => zio.aws.workdocs.model.LongRangeType.wrap(value))
    override val createdRange
        : Optional[zio.aws.workdocs.model.DateRangeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdRange())
        .map(value => zio.aws.workdocs.model.DateRangeType.wrap(value))
    override val modifiedRange
        : Optional[zio.aws.workdocs.model.DateRangeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedRange())
        .map(value => zio.aws.workdocs.model.DateRangeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Filters
  ): zio.aws.workdocs.model.Filters.ReadOnly = new Wrapper(impl)
}
