package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.MarkerType
import scala.jdk.CollectionConverters._
final case class DescribeCommentsResponse(
    comments: Optional[Iterable[zio.aws.workdocs.model.Comment]] =
      Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse = {
    import DescribeCommentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse
      .builder()
      .optionallyWith(
        comments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comments)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeCommentsResponse.wrap(buildAwsValue())
}
object DescribeCommentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeCommentsResponse =
      zio.aws.workdocs.model.DescribeCommentsResponse(
        comments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def comments: Optional[List[zio.aws.workdocs.model.Comment.ReadOnly]]
    def marker: Optional[MarkerType]
    def getComments
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.Comment.ReadOnly]] =
      AwsError.unwrapOptionField("comments", comments)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse
  ) extends zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly {
    override val comments
        : Optional[List[zio.aws.workdocs.model.Comment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.Comment.wrap(item)
          }.toList
        )
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse
  ): zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
