package zio.aws.workdocs
import zio.aws.workdocs.model.AddResourcePermissionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.workdocs.model.{
  DescribeNotificationSubscriptionsRequest,
  DeleteUserRequest,
  RemoveAllResourcePermissionsRequest,
  CreateCommentRequest,
  DeleteFolderRequest,
  DeleteCommentRequest,
  GetCurrentUserRequest,
  DescribeDocumentVersionsResponse,
  DescribeFolderContentsRequest,
  DescribeUsersRequest,
  SearchResourcesRequest,
  DescribeResourcePermissionsRequest,
  CreateLabelsResponse,
  Comment,
  AddResourcePermissionsResponse,
  ResponseItem,
  DeleteLabelsRequest,
  UpdateDocumentResponse,
  InitiateDocumentVersionUploadResponse,
  AbortDocumentVersionUploadRequest,
  UpdateFolderResponse,
  GetCurrentUserResponse,
  DescribeGroupsRequest,
  CreateLabelsRequest,
  RemoveResourcePermissionResponse,
  User,
  DescribeResourcePermissionsResponse,
  CreateNotificationSubscriptionResponse,
  RemoveAllResourcePermissionsResponse,
  RestoreDocumentVersionsRequest,
  CreateCustomMetadataRequest,
  UpdateFolderRequest,
  Subscription,
  GetDocumentResponse,
  AddResourcePermissionsRequest,
  GetFolderResponse,
  DescribeGroupsResponse,
  DescribeRootFoldersResponse,
  GroupMetadata,
  DeleteFolderResponse,
  UpdateDocumentRequest,
  DeactivateUserRequest,
  FolderMetadata,
  RestoreDocumentVersionsResponse,
  DeleteDocumentResponse,
  SearchResourcesResponse,
  Activity,
  CreateUserRequest,
  ActivateUserResponse,
  GetFolderRequest,
  ActivateUserRequest,
  DescribeFolderContentsResponse,
  CreateUserResponse,
  DescribeCommentsRequest,
  RemoveResourcePermissionRequest,
  CreateFolderResponse,
  DescribeUsersResponse,
  DescribeDocumentVersionsRequest,
  DeleteFolderContentsResponse,
  DescribeActivitiesRequest,
  DeleteCustomMetadataResponse,
  UpdateDocumentVersionRequest,
  DeleteNotificationSubscriptionRequest,
  DescribeCommentsResponse,
  DeleteNotificationSubscriptionResponse,
  DeleteLabelsResponse,
  GetDocumentVersionResponse,
  DeleteDocumentRequest,
  DescribeRootFoldersRequest,
  DocumentVersionMetadata,
  DeleteUserResponse,
  GetDocumentPathResponse,
  AbortDocumentVersionUploadResponse,
  DeleteFolderContentsRequest,
  UpdateUserRequest,
  GetFolderPathResponse,
  GetDocumentPathRequest,
  GetDocumentRequest,
  GetResourcesResponse,
  UpdateDocumentVersionResponse,
  GetFolderPathRequest,
  InitiateDocumentVersionUploadRequest,
  DeleteCustomMetadataRequest,
  GetResourcesRequest,
  CreateNotificationSubscriptionRequest,
  UpdateUserResponse,
  DescribeNotificationSubscriptionsResponse,
  DeleteCommentResponse,
  CreateCommentResponse,
  CreateCustomMetadataResponse,
  GetDocumentVersionRequest,
  CreateFolderRequest,
  DeactivateUserResponse,
  Principal,
  DeleteDocumentVersionRequest,
  DeleteDocumentVersionResponse,
  DescribeActivitiesResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.workdocs.{
  WorkDocsAsyncClientBuilder,
  WorkDocsAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.workdocs.paginators.{
  DescribeCommentsPublisher,
  SearchResourcesPublisher,
  DescribeResourcePermissionsPublisher,
  DescribeFolderContentsPublisher,
  DescribeDocumentVersionsPublisher,
  DescribeRootFoldersPublisher,
  DescribeGroupsPublisher,
  DescribeActivitiesPublisher,
  DescribeNotificationSubscriptionsPublisher,
  DescribeUsersPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait WorkDocs extends AspectSupport[WorkDocs] {
  val api: WorkDocsAsyncClient
  def getDocumentPath(
      request: zio.aws.workdocs.model.GetDocumentPathRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly]
  def createLabels(
      request: zio.aws.workdocs.model.CreateLabelsRequest
  ): IO[AwsError, zio.aws.workdocs.model.CreateLabelsResponse.ReadOnly]
  def getCurrentUser(
      request: zio.aws.workdocs.model.GetCurrentUserRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly]
  def updateUser(
      request: zio.aws.workdocs.model.UpdateUserRequest
  ): IO[AwsError, zio.aws.workdocs.model.UpdateUserResponse.ReadOnly]
  def getFolderPath(
      request: zio.aws.workdocs.model.GetFolderPathRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly]
  def removeAllResourcePermissions(
      request: zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest
  ): IO[AwsError, Unit]
  def activateUser(
      request: zio.aws.workdocs.model.ActivateUserRequest
  ): IO[AwsError, zio.aws.workdocs.model.ActivateUserResponse.ReadOnly]
  def createNotificationSubscription(
      request: zio.aws.workdocs.model.CreateNotificationSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly
  ]
  def abortDocumentVersionUpload(
      request: zio.aws.workdocs.model.AbortDocumentVersionUploadRequest
  ): IO[AwsError, Unit]
  def describeActivities(
      request: zio.aws.workdocs.model.DescribeActivitiesRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.Activity.ReadOnly]
  def describeActivitiesPaginated(
      request: zio.aws.workdocs.model.DescribeActivitiesRequest
  ): IO[AwsError, zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly]
  def deleteComment(
      request: zio.aws.workdocs.model.DeleteCommentRequest
  ): IO[AwsError, Unit]
  def getDocument(
      request: zio.aws.workdocs.model.GetDocumentRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetDocumentResponse.ReadOnly]
  def describeResourcePermissions(
      request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.Principal.ReadOnly]
  def describeResourcePermissionsPaginated(
      request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly
  ]
  def deleteDocumentVersion(
      request: zio.aws.workdocs.model.DeleteDocumentVersionRequest
  ): IO[AwsError, Unit]
  def deleteFolderContents(
      request: zio.aws.workdocs.model.DeleteFolderContentsRequest
  ): IO[AwsError, Unit]
  def deleteFolder(
      request: zio.aws.workdocs.model.DeleteFolderRequest
  ): IO[AwsError, Unit]
  def deleteLabels(
      request: zio.aws.workdocs.model.DeleteLabelsRequest
  ): IO[AwsError, zio.aws.workdocs.model.DeleteLabelsResponse.ReadOnly]
  def createUser(
      request: zio.aws.workdocs.model.CreateUserRequest
  ): IO[AwsError, zio.aws.workdocs.model.CreateUserResponse.ReadOnly]
  def getFolder(
      request: zio.aws.workdocs.model.GetFolderRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetFolderResponse.ReadOnly]
  def describeRootFolders(
      request: zio.aws.workdocs.model.DescribeRootFoldersRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly]
  def describeRootFoldersPaginated(
      request: zio.aws.workdocs.model.DescribeRootFoldersRequest
  ): IO[AwsError, zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly]
  def createComment(
      request: zio.aws.workdocs.model.CreateCommentRequest
  ): IO[AwsError, zio.aws.workdocs.model.CreateCommentResponse.ReadOnly]
  def getResources(
      request: zio.aws.workdocs.model.GetResourcesRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetResourcesResponse.ReadOnly]
  def searchResources(
      request: zio.aws.workdocs.model.SearchResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.ResponseItem.ReadOnly]
  def searchResourcesPaginated(
      request: zio.aws.workdocs.model.SearchResourcesRequest
  ): IO[AwsError, zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly]
  def addResourcePermissions(
      request: zio.aws.workdocs.model.AddResourcePermissionsRequest
  ): IO[AwsError, ReadOnly]
  def describeUsers(
      request: zio.aws.workdocs.model.DescribeUsersRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly]
  def describeUsersPaginated(
      request: zio.aws.workdocs.model.DescribeUsersRequest
  ): IO[AwsError, zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly]
  def updateDocument(
      request: zio.aws.workdocs.model.UpdateDocumentRequest
  ): IO[AwsError, Unit]
  def restoreDocumentVersions(
      request: zio.aws.workdocs.model.RestoreDocumentVersionsRequest
  ): IO[AwsError, Unit]
  def describeNotificationSubscriptions(
      request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.Subscription.ReadOnly]
  def describeNotificationSubscriptionsPaginated(
      request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly
  ]
  def createCustomMetadata(
      request: zio.aws.workdocs.model.CreateCustomMetadataRequest
  ): IO[AwsError, zio.aws.workdocs.model.CreateCustomMetadataResponse.ReadOnly]
  def deleteCustomMetadata(
      request: zio.aws.workdocs.model.DeleteCustomMetadataRequest
  ): IO[AwsError, zio.aws.workdocs.model.DeleteCustomMetadataResponse.ReadOnly]
  def describeComments(
      request: zio.aws.workdocs.model.DescribeCommentsRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.Comment.ReadOnly]
  def describeCommentsPaginated(
      request: zio.aws.workdocs.model.DescribeCommentsRequest
  ): IO[AwsError, zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly]
  def describeGroups(
      request: zio.aws.workdocs.model.DescribeGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.GroupMetadata.ReadOnly]
  def describeGroupsPaginated(
      request: zio.aws.workdocs.model.DescribeGroupsRequest
  ): IO[AwsError, zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly]
  def initiateDocumentVersionUpload(
      request: zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly
  ]
  def describeFolderContents(
      request: zio.aws.workdocs.model.DescribeFolderContentsRequest
  ): ZStream[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly]
  def describeFolderContentsPaginated(
      request: zio.aws.workdocs.model.DescribeFolderContentsRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly
  ]
  def updateFolder(
      request: zio.aws.workdocs.model.UpdateFolderRequest
  ): IO[AwsError, Unit]
  def deleteUser(
      request: zio.aws.workdocs.model.DeleteUserRequest
  ): IO[AwsError, Unit]
  def updateDocumentVersion(
      request: zio.aws.workdocs.model.UpdateDocumentVersionRequest
  ): IO[AwsError, Unit]
  def createFolder(
      request: zio.aws.workdocs.model.CreateFolderRequest
  ): IO[AwsError, zio.aws.workdocs.model.CreateFolderResponse.ReadOnly]
  def getDocumentVersion(
      request: zio.aws.workdocs.model.GetDocumentVersionRequest
  ): IO[AwsError, zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly]
  def removeResourcePermission(
      request: zio.aws.workdocs.model.RemoveResourcePermissionRequest
  ): IO[AwsError, Unit]
  def deleteNotificationSubscription(
      request: zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest
  ): IO[AwsError, Unit]
  def deleteDocument(
      request: zio.aws.workdocs.model.DeleteDocumentRequest
  ): IO[AwsError, Unit]
  def describeDocumentVersions(
      request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
  ]
  def describeDocumentVersionsPaginated(
      request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
  ): IO[
    AwsError,
    zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly
  ]
  def deactivateUser(
      request: zio.aws.workdocs.model.DeactivateUserRequest
  ): IO[AwsError, Unit]
}
object WorkDocs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, WorkDocs] = customized(
    identity
  )
  def customized(
      customization: WorkDocsAsyncClientBuilder => WorkDocsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, WorkDocs] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: WorkDocsAsyncClientBuilder => WorkDocsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, WorkDocs] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = WorkDocsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[WorkDocsAsyncClient, WorkDocsAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[WorkDocsAsyncClient, WorkDocsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new WorkDocsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class WorkDocsImpl[R](
      override val api: WorkDocsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends WorkDocs
      with AwsServiceBase[R] {
    override val serviceName: String = "WorkDocs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): WorkDocsImpl[R1] = new WorkDocsImpl(api, newAspect, r)
    def getDocumentPath(
        request: zio.aws.workdocs.model.GetDocumentPathRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly] =
      asyncRequestResponse[GetDocumentPathRequest, GetDocumentPathResponse](
        "getDocumentPath",
        api.getDocumentPath
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetDocumentPathResponse.wrap)
        .provideEnvironment(r)
    def createLabels(
        request: zio.aws.workdocs.model.CreateLabelsRequest
    ): IO[AwsError, zio.aws.workdocs.model.CreateLabelsResponse.ReadOnly] =
      asyncRequestResponse[CreateLabelsRequest, CreateLabelsResponse](
        "createLabels",
        api.createLabels
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.CreateLabelsResponse.wrap)
        .provideEnvironment(r)
    def getCurrentUser(
        request: zio.aws.workdocs.model.GetCurrentUserRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly] =
      asyncRequestResponse[GetCurrentUserRequest, GetCurrentUserResponse](
        "getCurrentUser",
        api.getCurrentUser
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetCurrentUserResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: zio.aws.workdocs.model.UpdateUserRequest
    ): IO[AwsError, zio.aws.workdocs.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def getFolderPath(
        request: zio.aws.workdocs.model.GetFolderPathRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly] =
      asyncRequestResponse[GetFolderPathRequest, GetFolderPathResponse](
        "getFolderPath",
        api.getFolderPath
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetFolderPathResponse.wrap)
        .provideEnvironment(r)
    def removeAllResourcePermissions(
        request: zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveAllResourcePermissionsRequest,
      RemoveAllResourcePermissionsResponse
    ]("removeAllResourcePermissions", api.removeAllResourcePermissions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def activateUser(
        request: zio.aws.workdocs.model.ActivateUserRequest
    ): IO[AwsError, zio.aws.workdocs.model.ActivateUserResponse.ReadOnly] =
      asyncRequestResponse[ActivateUserRequest, ActivateUserResponse](
        "activateUser",
        api.activateUser
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.ActivateUserResponse.wrap)
        .provideEnvironment(r)
    def createNotificationSubscription(
        request: zio.aws.workdocs.model.CreateNotificationSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNotificationSubscriptionRequest,
      CreateNotificationSubscriptionResponse
    ]("createNotificationSubscription", api.createNotificationSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def abortDocumentVersionUpload(
        request: zio.aws.workdocs.model.AbortDocumentVersionUploadRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AbortDocumentVersionUploadRequest,
      AbortDocumentVersionUploadResponse
    ]("abortDocumentVersionUpload", api.abortDocumentVersionUpload)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeActivities(
        request: zio.aws.workdocs.model.DescribeActivitiesRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.Activity.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeActivitiesRequest,
        Activity,
        DescribeActivitiesPublisher
      ](
        "describeActivities",
        api.describeActivitiesPaginator,
        _.userActivities()
      )(request.buildAwsValue())
        .map(item => zio.aws.workdocs.model.Activity.wrap(item))
        .provideEnvironment(r)
    def describeActivitiesPaginated(
        request: zio.aws.workdocs.model.DescribeActivitiesRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeActivitiesRequest,
      DescribeActivitiesResponse
    ]("describeActivities", api.describeActivities)(request.buildAwsValue())
      .map(zio.aws.workdocs.model.DescribeActivitiesResponse.wrap)
      .provideEnvironment(r)
    def deleteComment(
        request: zio.aws.workdocs.model.DeleteCommentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteCommentRequest, DeleteCommentResponse](
        "deleteComment",
        api.deleteComment
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getDocument(
        request: zio.aws.workdocs.model.GetDocumentRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetDocumentResponse.ReadOnly] =
      asyncRequestResponse[GetDocumentRequest, GetDocumentResponse](
        "getDocument",
        api.getDocument
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetDocumentResponse.wrap)
        .provideEnvironment(r)
    def describeResourcePermissions(
        request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.Principal.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeResourcePermissionsRequest,
        Principal,
        DescribeResourcePermissionsPublisher
      ](
        "describeResourcePermissions",
        api.describeResourcePermissionsPaginator,
        _.principals()
      )(request.buildAwsValue())
        .map(item => zio.aws.workdocs.model.Principal.wrap(item))
        .provideEnvironment(r)
    def describeResourcePermissionsPaginated(
        request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeResourcePermissionsRequest,
      DescribeResourcePermissionsResponse
    ]("describeResourcePermissions", api.describeResourcePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.DescribeResourcePermissionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDocumentVersion(
        request: zio.aws.workdocs.model.DeleteDocumentVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDocumentVersionRequest,
      DeleteDocumentVersionResponse
    ]("deleteDocumentVersion", api.deleteDocumentVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteFolderContents(
        request: zio.aws.workdocs.model.DeleteFolderContentsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteFolderContentsRequest,
      DeleteFolderContentsResponse
    ]("deleteFolderContents", api.deleteFolderContents)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteFolder(
        request: zio.aws.workdocs.model.DeleteFolderRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFolderRequest, DeleteFolderResponse](
        "deleteFolder",
        api.deleteFolder
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteLabels(
        request: zio.aws.workdocs.model.DeleteLabelsRequest
    ): IO[AwsError, zio.aws.workdocs.model.DeleteLabelsResponse.ReadOnly] =
      asyncRequestResponse[DeleteLabelsRequest, DeleteLabelsResponse](
        "deleteLabels",
        api.deleteLabels
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.DeleteLabelsResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: zio.aws.workdocs.model.CreateUserRequest
    ): IO[AwsError, zio.aws.workdocs.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def getFolder(
        request: zio.aws.workdocs.model.GetFolderRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetFolderResponse.ReadOnly] =
      asyncRequestResponse[GetFolderRequest, GetFolderResponse](
        "getFolder",
        api.getFolder
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetFolderResponse.wrap)
        .provideEnvironment(r)
    def describeRootFolders(
        request: zio.aws.workdocs.model.DescribeRootFoldersRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeRootFoldersRequest,
        FolderMetadata,
        DescribeRootFoldersPublisher
      ]("describeRootFolders", api.describeRootFoldersPaginator, _.folders())(
        request.buildAwsValue()
      ).map(item => zio.aws.workdocs.model.FolderMetadata.wrap(item))
        .provideEnvironment(r)
    def describeRootFoldersPaginated(
        request: zio.aws.workdocs.model.DescribeRootFoldersRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRootFoldersRequest,
      DescribeRootFoldersResponse
    ]("describeRootFolders", api.describeRootFolders)(request.buildAwsValue())
      .map(zio.aws.workdocs.model.DescribeRootFoldersResponse.wrap)
      .provideEnvironment(r)
    def createComment(
        request: zio.aws.workdocs.model.CreateCommentRequest
    ): IO[AwsError, zio.aws.workdocs.model.CreateCommentResponse.ReadOnly] =
      asyncRequestResponse[CreateCommentRequest, CreateCommentResponse](
        "createComment",
        api.createComment
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.CreateCommentResponse.wrap)
        .provideEnvironment(r)
    def getResources(
        request: zio.aws.workdocs.model.GetResourcesRequest
    ): IO[AwsError, zio.aws.workdocs.model.GetResourcesResponse.ReadOnly] =
      asyncRequestResponse[GetResourcesRequest, GetResourcesResponse](
        "getResources",
        api.getResources
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.GetResourcesResponse.wrap)
        .provideEnvironment(r)
    def searchResources(
        request: zio.aws.workdocs.model.SearchResourcesRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.ResponseItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        SearchResourcesRequest,
        ResponseItem,
        SearchResourcesPublisher
      ]("searchResources", api.searchResourcesPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.workdocs.model.ResponseItem.wrap(item))
        .provideEnvironment(r)
    def searchResourcesPaginated(
        request: zio.aws.workdocs.model.SearchResourcesRequest
    ): IO[AwsError, zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly] =
      asyncRequestResponse[SearchResourcesRequest, SearchResourcesResponse](
        "searchResources",
        api.searchResources
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.SearchResourcesResponse.wrap)
        .provideEnvironment(r)
    def addResourcePermissions(
        request: zio.aws.workdocs.model.AddResourcePermissionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      AddResourcePermissionsRequest,
      AddResourcePermissionsResponse
    ]("addResourcePermissions", api.addResourcePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.AddResourcePermissionsResponse.wrap)
      .provideEnvironment(r)
    def describeUsers(
        request: zio.aws.workdocs.model.DescribeUsersRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeUsersRequest,
        User,
        DescribeUsersPublisher
      ]("describeUsers", api.describeUsersPaginator, _.users())(
        request.buildAwsValue()
      ).map(item => zio.aws.workdocs.model.User.wrap(item))
        .provideEnvironment(r)
    def describeUsersPaginated(
        request: zio.aws.workdocs.model.DescribeUsersRequest
    ): IO[AwsError, zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly] =
      asyncRequestResponse[DescribeUsersRequest, DescribeUsersResponse](
        "describeUsers",
        api.describeUsers
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.DescribeUsersResponse.wrap)
        .provideEnvironment(r)
    def updateDocument(
        request: zio.aws.workdocs.model.UpdateDocumentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateDocumentRequest, UpdateDocumentResponse](
        "updateDocument",
        api.updateDocument
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def restoreDocumentVersions(
        request: zio.aws.workdocs.model.RestoreDocumentVersionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RestoreDocumentVersionsRequest,
      RestoreDocumentVersionsResponse
    ]("restoreDocumentVersions", api.restoreDocumentVersions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeNotificationSubscriptions(
        request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.Subscription.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeNotificationSubscriptionsRequest,
        Subscription,
        DescribeNotificationSubscriptionsPublisher
      ](
        "describeNotificationSubscriptions",
        api.describeNotificationSubscriptionsPaginator,
        _.subscriptions()
      )(request.buildAwsValue())
        .map(item => zio.aws.workdocs.model.Subscription.wrap(item))
        .provideEnvironment(r)
    def describeNotificationSubscriptionsPaginated(
        request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNotificationSubscriptionsRequest,
      DescribeNotificationSubscriptionsResponse
    ](
      "describeNotificationSubscriptions",
      api.describeNotificationSubscriptions
    )(request.buildAwsValue())
      .map(
        zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.wrap
      )
      .provideEnvironment(r)
    def createCustomMetadata(
        request: zio.aws.workdocs.model.CreateCustomMetadataRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.CreateCustomMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomMetadataRequest,
      CreateCustomMetadataResponse
    ]("createCustomMetadata", api.createCustomMetadata)(request.buildAwsValue())
      .map(zio.aws.workdocs.model.CreateCustomMetadataResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomMetadata(
        request: zio.aws.workdocs.model.DeleteCustomMetadataRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DeleteCustomMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCustomMetadataRequest,
      DeleteCustomMetadataResponse
    ]("deleteCustomMetadata", api.deleteCustomMetadata)(request.buildAwsValue())
      .map(zio.aws.workdocs.model.DeleteCustomMetadataResponse.wrap)
      .provideEnvironment(r)
    def describeComments(
        request: zio.aws.workdocs.model.DescribeCommentsRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.Comment.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeCommentsRequest,
        Comment,
        DescribeCommentsPublisher
      ]("describeComments", api.describeCommentsPaginator, _.comments())(
        request.buildAwsValue()
      ).map(item => zio.aws.workdocs.model.Comment.wrap(item))
        .provideEnvironment(r)
    def describeCommentsPaginated(
        request: zio.aws.workdocs.model.DescribeCommentsRequest
    ): IO[AwsError, zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly] =
      asyncRequestResponse[DescribeCommentsRequest, DescribeCommentsResponse](
        "describeComments",
        api.describeComments
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.DescribeCommentsResponse.wrap)
        .provideEnvironment(r)
    def describeGroups(
        request: zio.aws.workdocs.model.DescribeGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.GroupMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeGroupsRequest,
        GroupMetadata,
        DescribeGroupsPublisher
      ]("describeGroups", api.describeGroupsPaginator, _.groups())(
        request.buildAwsValue()
      ).map(item => zio.aws.workdocs.model.GroupMetadata.wrap(item))
        .provideEnvironment(r)
    def describeGroupsPaginated(
        request: zio.aws.workdocs.model.DescribeGroupsRequest
    ): IO[AwsError, zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly] =
      asyncRequestResponse[DescribeGroupsRequest, DescribeGroupsResponse](
        "describeGroups",
        api.describeGroups
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.DescribeGroupsResponse.wrap)
        .provideEnvironment(r)
    def initiateDocumentVersionUpload(
        request: zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      InitiateDocumentVersionUploadRequest,
      InitiateDocumentVersionUploadResponse
    ]("initiateDocumentVersionUpload", api.initiateDocumentVersionUpload)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.wrap)
      .provideEnvironment(r)
    def describeFolderContents(
        request: zio.aws.workdocs.model.DescribeFolderContentsRequest
    ): ZStream[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeFolderContentsRequest,
        FolderMetadata,
        DescribeFolderContentsPublisher
      ](
        "describeFolderContents",
        api.describeFolderContentsPaginator,
        _.folders()
      )(request.buildAwsValue())
        .map(item => zio.aws.workdocs.model.FolderMetadata.wrap(item))
        .provideEnvironment(r)
    def describeFolderContentsPaginated(
        request: zio.aws.workdocs.model.DescribeFolderContentsRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFolderContentsRequest,
      DescribeFolderContentsResponse
    ]("describeFolderContents", api.describeFolderContents)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.DescribeFolderContentsResponse.wrap)
      .provideEnvironment(r)
    def updateFolder(
        request: zio.aws.workdocs.model.UpdateFolderRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateFolderRequest, UpdateFolderResponse](
        "updateFolder",
        api.updateFolder
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteUser(
        request: zio.aws.workdocs.model.DeleteUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateDocumentVersion(
        request: zio.aws.workdocs.model.UpdateDocumentVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateDocumentVersionRequest,
      UpdateDocumentVersionResponse
    ]("updateDocumentVersion", api.updateDocumentVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createFolder(
        request: zio.aws.workdocs.model.CreateFolderRequest
    ): IO[AwsError, zio.aws.workdocs.model.CreateFolderResponse.ReadOnly] =
      asyncRequestResponse[CreateFolderRequest, CreateFolderResponse](
        "createFolder",
        api.createFolder
      )(request.buildAwsValue())
        .map(zio.aws.workdocs.model.CreateFolderResponse.wrap)
        .provideEnvironment(r)
    def getDocumentVersion(
        request: zio.aws.workdocs.model.GetDocumentVersionRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentVersionRequest,
      GetDocumentVersionResponse
    ]("getDocumentVersion", api.getDocumentVersion)(request.buildAwsValue())
      .map(zio.aws.workdocs.model.GetDocumentVersionResponse.wrap)
      .provideEnvironment(r)
    def removeResourcePermission(
        request: zio.aws.workdocs.model.RemoveResourcePermissionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveResourcePermissionRequest,
      RemoveResourcePermissionResponse
    ]("removeResourcePermission", api.removeResourcePermission)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteNotificationSubscription(
        request: zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteNotificationSubscriptionRequest,
      DeleteNotificationSubscriptionResponse
    ]("deleteNotificationSubscription", api.deleteNotificationSubscription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteDocument(
        request: zio.aws.workdocs.model.DeleteDocumentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDocumentRequest, DeleteDocumentResponse](
        "deleteDocument",
        api.deleteDocument
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeDocumentVersions(
        request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeDocumentVersionsRequest,
      DocumentVersionMetadata,
      DescribeDocumentVersionsPublisher
    ](
      "describeDocumentVersions",
      api.describeDocumentVersionsPaginator,
      _.documentVersions()
    )(request.buildAwsValue())
      .map(item => zio.aws.workdocs.model.DocumentVersionMetadata.wrap(item))
      .provideEnvironment(r)
    def describeDocumentVersionsPaginated(
        request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
    ): IO[
      AwsError,
      zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDocumentVersionsRequest,
      DescribeDocumentVersionsResponse
    ]("describeDocumentVersions", api.describeDocumentVersions)(
      request.buildAwsValue()
    ).map(zio.aws.workdocs.model.DescribeDocumentVersionsResponse.wrap)
      .provideEnvironment(r)
    def deactivateUser(
        request: zio.aws.workdocs.model.DeactivateUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeactivateUserRequest, DeactivateUserResponse](
        "deactivateUser",
        api.deactivateUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
  }
  def getDocumentPath(
      request: zio.aws.workdocs.model.GetDocumentPathRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentPath(request))
  def createLabels(request: zio.aws.workdocs.model.CreateLabelsRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLabels(request))
  def getCurrentUser(
      request: zio.aws.workdocs.model.GetCurrentUserRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCurrentUser(request))
  def updateUser(request: zio.aws.workdocs.model.UpdateUserRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def getFolderPath(request: zio.aws.workdocs.model.GetFolderPathRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFolderPath(request))
  def removeAllResourcePermissions(
      request: zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeAllResourcePermissions(request))
  def activateUser(request: zio.aws.workdocs.model.ActivateUserRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.ActivateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateUser(request))
  def createNotificationSubscription(
      request: zio.aws.workdocs.model.CreateNotificationSubscriptionRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNotificationSubscription(request))
  def abortDocumentVersionUpload(
      request: zio.aws.workdocs.model.AbortDocumentVersionUploadRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.abortDocumentVersionUpload(request))
  def describeActivities(
      request: zio.aws.workdocs.model.DescribeActivitiesRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.Activity.ReadOnly
  ] = ZStream.serviceWithStream(_.describeActivities(request))
  def describeActivitiesPaginated(
      request: zio.aws.workdocs.model.DescribeActivitiesRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActivitiesPaginated(request))
  def deleteComment(
      request: zio.aws.workdocs.model.DeleteCommentRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteComment(request))
  def getDocument(request: zio.aws.workdocs.model.GetDocumentRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocument(request))
  def describeResourcePermissions(
      request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.Principal.ReadOnly
  ] = ZStream.serviceWithStream(_.describeResourcePermissions(request))
  def describeResourcePermissionsPaginated(
      request: zio.aws.workdocs.model.DescribeResourcePermissionsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourcePermissionsPaginated(request))
  def deleteDocumentVersion(
      request: zio.aws.workdocs.model.DeleteDocumentVersionRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDocumentVersion(request))
  def deleteFolderContents(
      request: zio.aws.workdocs.model.DeleteFolderContentsRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFolderContents(request))
  def deleteFolder(
      request: zio.aws.workdocs.model.DeleteFolderRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFolder(request))
  def deleteLabels(request: zio.aws.workdocs.model.DeleteLabelsRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DeleteLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLabels(request))
  def createUser(request: zio.aws.workdocs.model.CreateUserRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def getFolder(request: zio.aws.workdocs.model.GetFolderRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFolder(request))
  def describeRootFolders(
      request: zio.aws.workdocs.model.DescribeRootFoldersRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.FolderMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRootFolders(request))
  def describeRootFoldersPaginated(
      request: zio.aws.workdocs.model.DescribeRootFoldersRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRootFoldersPaginated(request))
  def createComment(request: zio.aws.workdocs.model.CreateCommentRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateCommentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComment(request))
  def getResources(request: zio.aws.workdocs.model.GetResourcesRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResources(request))
  def searchResources(
      request: zio.aws.workdocs.model.SearchResourcesRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.ResponseItem.ReadOnly
  ] = ZStream.serviceWithStream(_.searchResources(request))
  def searchResourcesPaginated(
      request: zio.aws.workdocs.model.SearchResourcesRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchResourcesPaginated(request))
  def addResourcePermissions(
      request: zio.aws.workdocs.model.AddResourcePermissionsRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.addResourcePermissions(request))
  def describeUsers(
      request: zio.aws.workdocs.model.DescribeUsersRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsers(request))
  def describeUsersPaginated(
      request: zio.aws.workdocs.model.DescribeUsersRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsersPaginated(request))
  def updateDocument(
      request: zio.aws.workdocs.model.UpdateDocumentRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDocument(request))
  def restoreDocumentVersions(
      request: zio.aws.workdocs.model.RestoreDocumentVersionsRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.restoreDocumentVersions(request))
  def describeNotificationSubscriptions(
      request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.Subscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNotificationSubscriptions(request))
  def describeNotificationSubscriptionsPaginated(
      request: zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNotificationSubscriptionsPaginated(request))
  def createCustomMetadata(
      request: zio.aws.workdocs.model.CreateCustomMetadataRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateCustomMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomMetadata(request))
  def deleteCustomMetadata(
      request: zio.aws.workdocs.model.DeleteCustomMetadataRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DeleteCustomMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomMetadata(request))
  def describeComments(
      request: zio.aws.workdocs.model.DescribeCommentsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.Comment.ReadOnly
  ] = ZStream.serviceWithStream(_.describeComments(request))
  def describeCommentsPaginated(
      request: zio.aws.workdocs.model.DescribeCommentsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCommentsPaginated(request))
  def describeGroups(
      request: zio.aws.workdocs.model.DescribeGroupsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GroupMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGroups(request))
  def describeGroupsPaginated(
      request: zio.aws.workdocs.model.DescribeGroupsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGroupsPaginated(request))
  def initiateDocumentVersionUpload(
      request: zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateDocumentVersionUpload(request))
  def describeFolderContents(
      request: zio.aws.workdocs.model.DescribeFolderContentsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.FolderMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFolderContents(request))
  def describeFolderContentsPaginated(
      request: zio.aws.workdocs.model.DescribeFolderContentsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFolderContentsPaginated(request))
  def updateFolder(
      request: zio.aws.workdocs.model.UpdateFolderRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateFolder(request))
  def deleteUser(
      request: zio.aws.workdocs.model.DeleteUserRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUser(request))
  def updateDocumentVersion(
      request: zio.aws.workdocs.model.UpdateDocumentVersionRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDocumentVersion(request))
  def createFolder(request: zio.aws.workdocs.model.CreateFolderRequest): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.CreateFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFolder(request))
  def getDocumentVersion(
      request: zio.aws.workdocs.model.GetDocumentVersionRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentVersion(request))
  def removeResourcePermission(
      request: zio.aws.workdocs.model.RemoveResourcePermissionRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeResourcePermission(request))
  def deleteNotificationSubscription(
      request: zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNotificationSubscription(request))
  def deleteDocument(
      request: zio.aws.workdocs.model.DeleteDocumentRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDocument(request))
  def describeDocumentVersions(
      request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
  ): ZStream[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDocumentVersions(request))
  def describeDocumentVersionsPaginated(
      request: zio.aws.workdocs.model.DescribeDocumentVersionsRequest
  ): ZIO[
    zio.aws.workdocs.WorkDocs,
    AwsError,
    zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDocumentVersionsPaginated(request))
  def deactivateUser(
      request: zio.aws.workdocs.model.DeactivateUserRequest
  ): ZIO[zio.aws.workdocs.WorkDocs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deactivateUser(request))
}
