package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  HeaderValueType,
  HeaderNameType,
  UrlType
}
import scala.jdk.CollectionConverters._
final case class UploadMetadata(
    uploadUrl: Optional[UrlType] = Optional.Absent,
    signedHeaders: Optional[Map[HeaderNameType, HeaderValueType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UploadMetadata = {
    import UploadMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UploadMetadata
      .builder()
      .optionallyWith(
        uploadUrl.map(value => UrlType.unwrap(value): java.lang.String)
      )(_.uploadUrl)
      .optionallyWith(
        signedHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (HeaderNameType.unwrap(key): java.lang.String) -> (HeaderValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.signedHeaders)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UploadMetadata.ReadOnly =
    zio.aws.workdocs.model.UploadMetadata.wrap(buildAwsValue())
}
object UploadMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UploadMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UploadMetadata =
      zio.aws.workdocs.model.UploadMetadata(
        uploadUrl.map(value => value),
        signedHeaders.map(value => value)
      )
    def uploadUrl: Optional[UrlType]
    def signedHeaders: Optional[Map[HeaderNameType, HeaderValueType]]
    def getUploadUrl: ZIO[Any, AwsError, UrlType] =
      AwsError.unwrapOptionField("uploadUrl", uploadUrl)
    def getSignedHeaders
        : ZIO[Any, AwsError, Map[HeaderNameType, HeaderValueType]] =
      AwsError.unwrapOptionField("signedHeaders", signedHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UploadMetadata
  ) extends zio.aws.workdocs.model.UploadMetadata.ReadOnly {
    override val uploadUrl: Optional[UrlType] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadUrl())
      .map(value => zio.aws.workdocs.model.primitives.UrlType(value))
    override val signedHeaders: Optional[Map[HeaderNameType, HeaderValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signedHeaders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workdocs.model.primitives.HeaderNameType(
                key
              ) -> zio.aws.workdocs.model.primitives.HeaderValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UploadMetadata
  ): zio.aws.workdocs.model.UploadMetadata.ReadOnly = new Wrapper(impl)
}
