package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters._
final case class DescribeResourcePermissionsResponse(
    principals: Optional[Iterable[zio.aws.workdocs.model.Principal]] =
      Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse = {
    import DescribeResourcePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeResourcePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeResourcePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeResourcePermissionsResponse =
      zio.aws.workdocs.model.DescribeResourcePermissionsResponse(
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def principals: Optional[List[zio.aws.workdocs.model.Principal.ReadOnly]]
    def marker: Optional[PageMarkerType]
    def getPrincipals
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("principals", principals)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse
  ) extends zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly {
    override val principals
        : Optional[List[zio.aws.workdocs.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.Principal.wrap(item)
          }.toList
        )
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse
  ): zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
