package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class DeleteFolderContentsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    folderId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest = {
    import DeleteFolderContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteFolderContentsRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteFolderContentsRequest.wrap(buildAwsValue())
}
object DeleteFolderContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteFolderContentsRequest =
      zio.aws.workdocs.model.DeleteFolderContentsRequest(
        authenticationToken.map(value => value),
        folderId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest
  ) extends zio.aws.workdocs.model.DeleteFolderContentsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest
  ): zio.aws.workdocs.model.DeleteFolderContentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
