package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait DocumentStatusType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.DocumentStatusType
}
object DocumentStatusType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.DocumentStatusType
  ): zio.aws.workdocs.model.DocumentStatusType = value match {
    case software.amazon.awssdk.services.workdocs.model.DocumentStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentStatusType.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentStatusType.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.DocumentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentStatusType =
      software.amazon.awssdk.services.workdocs.model.DocumentStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.workdocs.model.DocumentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentStatusType =
      software.amazon.awssdk.services.workdocs.model.DocumentStatusType.INITIALIZED
  }
  case object ACTIVE extends zio.aws.workdocs.model.DocumentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentStatusType =
      software.amazon.awssdk.services.workdocs.model.DocumentStatusType.ACTIVE
  }
}
