package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFolderResponse(
    metadata: Optional[zio.aws.workdocs.model.FolderMetadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateFolderResponse = {
    import CreateFolderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateFolderResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateFolderResponse.ReadOnly =
    zio.aws.workdocs.model.CreateFolderResponse.wrap(buildAwsValue())
}
object CreateFolderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateFolderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateFolderResponse =
      zio.aws.workdocs.model
        .CreateFolderResponse(metadata.map(value => value.asEditable))
    def metadata: Optional[zio.aws.workdocs.model.FolderMetadata.ReadOnly]
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateFolderResponse
  ) extends zio.aws.workdocs.model.CreateFolderResponse.ReadOnly {
    override val metadata
        : Optional[zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.workdocs.model.FolderMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateFolderResponse
  ): zio.aws.workdocs.model.CreateFolderResponse.ReadOnly = new Wrapper(impl)
}
