package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  CommentTextType,
  DocumentVersionIdType,
  CommentIdType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters._
final case class CreateCommentRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    parentId: Optional[CommentIdType] = Optional.Absent,
    threadId: Optional[CommentIdType] = Optional.Absent,
    text: CommentTextType,
    visibility: Optional[zio.aws.workdocs.model.CommentVisibilityType] =
      Optional.Absent,
    notifyCollaborators: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateCommentRequest = {
    import CreateCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateCommentRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .optionallyWith(
        parentId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        threadId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.threadId)
      .text(CommentTextType.unwrap(text): java.lang.String)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        notifyCollaborators.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.notifyCollaborators)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateCommentRequest.ReadOnly =
    zio.aws.workdocs.model.CreateCommentRequest.wrap(buildAwsValue())
}
object CreateCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateCommentRequest =
      zio.aws.workdocs.model.CreateCommentRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        parentId.map(value => value),
        threadId.map(value => value),
        text,
        visibility.map(value => value),
        notifyCollaborators.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def parentId: Optional[CommentIdType]
    def threadId: Optional[CommentIdType]
    def text: CommentTextType
    def visibility: Optional[zio.aws.workdocs.model.CommentVisibilityType]
    def notifyCollaborators: Optional[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getParentId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getThreadId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("threadId", threadId)
    def getText: ZIO[Any, Nothing, CommentTextType] = ZIO.succeed(text)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentVisibilityType] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getNotifyCollaborators: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("notifyCollaborators", notifyCollaborators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentRequest
  ) extends zio.aws.workdocs.model.CreateCommentRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val parentId: Optional[CommentIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.parentId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val threadId: Optional[CommentIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.threadId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val text: CommentTextType =
      zio.aws.workdocs.model.primitives.CommentTextType(impl.text())
    override val visibility
        : Optional[zio.aws.workdocs.model.CommentVisibilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.workdocs.model.CommentVisibilityType.wrap(value))
    override val notifyCollaborators: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifyCollaborators())
        .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentRequest
  ): zio.aws.workdocs.model.CreateCommentRequest.ReadOnly = new Wrapper(impl)
}
