package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  IdType,
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDocumentPathRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: IdType,
    limit: Optional[LimitType] = Optional.Absent,
    fields: Optional[FieldNamesType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest = {
    import GetDocumentPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(IdType.unwrap(documentId): java.lang.String)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly =
    zio.aws.workdocs.model.GetDocumentPathRequest.wrap(buildAwsValue())
}
object GetDocumentPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentPathRequest =
      zio.aws.workdocs.model.GetDocumentPathRequest(
        authenticationToken.map(value => value),
        documentId,
        limit.map(value => value),
        fields.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: IdType
    def limit: Optional[LimitType]
    def fields: Optional[FieldNamesType]
    def marker: Optional[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(documentId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ) extends zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.documentId())
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val fields: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ): zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly = new Wrapper(impl)
}
