package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  IdType,
  TimestampType,
  ActivityNamesFilterType,
  LimitType,
  MarkerType,
  AuthenticationHeaderType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeActivitiesRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    startTime: Optional[TimestampType] = Optional.Absent,
    endTime: Optional[TimestampType] = Optional.Absent,
    organizationId: Optional[IdType] = Optional.Absent,
    activityTypes: Optional[ActivityNamesFilterType] = Optional.Absent,
    resourceId: Optional[IdType] = Optional.Absent,
    userId: Optional[IdType] = Optional.Absent,
    includeIndirectActivities: Optional[BooleanType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest = {
    import DescribeActivitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        startTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        activityTypes.map(value =>
          ActivityNamesFilterType.unwrap(value): java.lang.String
        )
      )(_.activityTypes)
      .optionallyWith(
        resourceId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        includeIndirectActivities.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeIndirectActivities)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeActivitiesRequest.wrap(buildAwsValue())
}
object DescribeActivitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeActivitiesRequest =
      zio.aws.workdocs.model.DescribeActivitiesRequest(
        authenticationToken.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        organizationId.map(value => value),
        activityTypes.map(value => value),
        resourceId.map(value => value),
        userId.map(value => value),
        includeIndirectActivities.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def startTime: Optional[TimestampType]
    def endTime: Optional[TimestampType]
    def organizationId: Optional[IdType]
    def activityTypes: Optional[ActivityNamesFilterType]
    def resourceId: Optional[IdType]
    def userId: Optional[IdType]
    def includeIndirectActivities: Optional[BooleanType]
    def limit: Optional[LimitType]
    def marker: Optional[MarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getActivityTypes: ZIO[Any, AwsError, ActivityNamesFilterType] =
      AwsError.unwrapOptionField("activityTypes", activityTypes)
    def getResourceId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getIncludeIndirectActivities: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("includeIndirectActivities", includeIndirectActivities)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ) extends zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val startTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val endTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val organizationId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val activityTypes: Optional[ActivityNamesFilterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityTypes())
        .map(value =>
          zio.aws.workdocs.model.primitives.ActivityNamesFilterType(value)
        )
    override val resourceId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val userId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val includeIndirectActivities: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeIndirectActivities())
        .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ): zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
