package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait ResourceSortType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ResourceSortType
}
object ResourceSortType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ResourceSortType
  ): zio.aws.workdocs.model.ResourceSortType = value match {
    case software.amazon.awssdk.services.workdocs.model.ResourceSortType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceSortType.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceSortType.NAME =>
      val r = NAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.ResourceSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceSortType =
      software.amazon.awssdk.services.workdocs.model.ResourceSortType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATE extends zio.aws.workdocs.model.ResourceSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceSortType =
      software.amazon.awssdk.services.workdocs.model.ResourceSortType.DATE
  }
  case object NAME extends zio.aws.workdocs.model.ResourceSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceSortType =
      software.amazon.awssdk.services.workdocs.model.ResourceSortType.NAME
  }
}
