package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  ResourceNameType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class CreateFolderRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    name: Optional[ResourceNameType] = Optional.Absent,
    parentFolderId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateFolderRequest = {
    import CreateFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateFolderRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .parentFolderId(ResourceIdType.unwrap(parentFolderId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateFolderRequest.ReadOnly =
    zio.aws.workdocs.model.CreateFolderRequest.wrap(buildAwsValue())
}
object CreateFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateFolderRequest =
      zio.aws.workdocs.model.CreateFolderRequest(
        authenticationToken.map(value => value),
        name.map(value => value),
        parentFolderId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def name: Optional[ResourceNameType]
    def parentFolderId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getParentFolderId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(parentFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateFolderRequest
  ) extends zio.aws.workdocs.model.CreateFolderRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val name: Optional[ResourceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val parentFolderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.parentFolderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateFolderRequest
  ): zio.aws.workdocs.model.CreateFolderRequest.ReadOnly = new Wrapper(impl)
}
