package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  IdType,
  TimestampType,
  CommentTextType,
  CommentIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Comment(
    commentId: CommentIdType,
    parentId: Optional[CommentIdType] = Optional.Absent,
    threadId: Optional[CommentIdType] = Optional.Absent,
    text: Optional[CommentTextType] = Optional.Absent,
    contributor: Optional[zio.aws.workdocs.model.User] = Optional.Absent,
    createdTimestamp: Optional[TimestampType] = Optional.Absent,
    status: Optional[zio.aws.workdocs.model.CommentStatusType] =
      Optional.Absent,
    visibility: Optional[zio.aws.workdocs.model.CommentVisibilityType] =
      Optional.Absent,
    recipientId: Optional[IdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Comment = {
    import Comment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Comment
      .builder()
      .commentId(CommentIdType.unwrap(commentId): java.lang.String)
      .optionallyWith(
        parentId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        threadId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.threadId)
      .optionallyWith(
        text.map(value => CommentTextType.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(contributor.map(value => value.buildAwsValue()))(
        _.contributor
      )
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        recipientId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.recipientId)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Comment.ReadOnly =
    zio.aws.workdocs.model.Comment.wrap(buildAwsValue())
}
object Comment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.Comment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Comment =
      zio.aws.workdocs.model.Comment(
        commentId,
        parentId.map(value => value),
        threadId.map(value => value),
        text.map(value => value),
        contributor.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        status.map(value => value),
        visibility.map(value => value),
        recipientId.map(value => value)
      )
    def commentId: CommentIdType
    def parentId: Optional[CommentIdType]
    def threadId: Optional[CommentIdType]
    def text: Optional[CommentTextType]
    def contributor: Optional[zio.aws.workdocs.model.User.ReadOnly]
    def createdTimestamp: Optional[TimestampType]
    def status: Optional[zio.aws.workdocs.model.CommentStatusType]
    def visibility: Optional[zio.aws.workdocs.model.CommentVisibilityType]
    def recipientId: Optional[IdType]
    def getCommentId: ZIO[Any, Nothing, CommentIdType] = ZIO.succeed(commentId)
    def getParentId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getThreadId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("threadId", threadId)
    def getText: ZIO[Any, AwsError, CommentTextType] =
      AwsError.unwrapOptionField("text", text)
    def getContributor
        : ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("contributor", contributor)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentVisibilityType] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getRecipientId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("recipientId", recipientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Comment
  ) extends zio.aws.workdocs.model.Comment.ReadOnly {
    override val commentId: CommentIdType =
      zio.aws.workdocs.model.primitives.CommentIdType(impl.commentId())
    override val parentId: Optional[CommentIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.parentId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val threadId: Optional[CommentIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.threadId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val text: Optional[CommentTextType] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => zio.aws.workdocs.model.primitives.CommentTextType(value))
    override val contributor: Optional[zio.aws.workdocs.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contributor())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
    override val createdTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val status: Optional[zio.aws.workdocs.model.CommentStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.workdocs.model.CommentStatusType.wrap(value))
    override val visibility
        : Optional[zio.aws.workdocs.model.CommentVisibilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.workdocs.model.CommentVisibilityType.wrap(value))
    override val recipientId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.recipientId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Comment
  ): zio.aws.workdocs.model.Comment.ReadOnly = new Wrapper(impl)
}
