package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType,
  ResourceIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDocumentVersionsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType,
    marker: Optional[PageMarkerType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    include: Optional[FieldNamesType] = Optional.Absent,
    fields: Optional[FieldNamesType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest = {
    import DescribeDocumentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        include.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.include)
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeDocumentVersionsRequest.wrap(buildAwsValue())
}
object DescribeDocumentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeDocumentVersionsRequest =
      zio.aws.workdocs.model.DescribeDocumentVersionsRequest(
        authenticationToken.map(value => value),
        documentId,
        marker.map(value => value),
        limit.map(value => value),
        include.map(value => value),
        fields.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def marker: Optional[PageMarkerType]
    def limit: Optional[LimitType]
    def include: Optional[FieldNamesType]
    def fields: Optional[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getInclude: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("include", include)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ) extends zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val include: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.include())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val fields: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest
  ): zio.aws.workdocs.model.DescribeDocumentVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
