package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{SubscriptionEndPointType, IdType}
import scala.jdk.CollectionConverters._
final case class Subscription(
    subscriptionId: Option[IdType] = None,
    endPoint: Option[SubscriptionEndPointType] = None,
    protocol: Option[zio.aws.workdocs.model.SubscriptionProtocolType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Subscription
      .builder()
      .optionallyWith(
        subscriptionId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.subscriptionId)
      .optionallyWith(
        endPoint.map(value =>
          SubscriptionEndPointType.unwrap(value): java.lang.String
        )
      )(_.endPoint)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Subscription.ReadOnly =
    zio.aws.workdocs.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.Subscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Subscription =
      zio.aws.workdocs.model.Subscription(
        subscriptionId.map(value => value),
        endPoint.map(value => value),
        protocol.map(value => value)
      )
    def subscriptionId: Option[IdType]
    def endPoint: Option[SubscriptionEndPointType]
    def protocol: Option[zio.aws.workdocs.model.SubscriptionProtocolType]
    def getSubscriptionId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("subscriptionId", subscriptionId)
    def getEndPoint: ZIO[Any, AwsError, SubscriptionEndPointType] =
      AwsError.unwrapOptionField("endPoint", endPoint)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.workdocs.model.SubscriptionProtocolType] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Subscription
  ) extends zio.aws.workdocs.model.Subscription.ReadOnly {
    override val subscriptionId: Option[IdType] = scala
      .Option(impl.subscriptionId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val endPoint: Option[SubscriptionEndPointType] = scala
      .Option(impl.endPoint())
      .map(value =>
        zio.aws.workdocs.model.primitives.SubscriptionEndPointType(value)
      )
    override val protocol
        : Option[zio.aws.workdocs.model.SubscriptionProtocolType] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.workdocs.model.SubscriptionProtocolType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Subscription
  ): zio.aws.workdocs.model.Subscription.ReadOnly = new Wrapper(impl)
}
