package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  CommentIdType,
  DocumentVersionIdType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class DeleteCommentRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    commentId: CommentIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest = {
    import DeleteCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .commentId(CommentIdType.unwrap(commentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteCommentRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteCommentRequest.wrap(buildAwsValue())
}
object DeleteCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteCommentRequest =
      zio.aws.workdocs.model.DeleteCommentRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        commentId
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def commentId: CommentIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getCommentId: ZIO[Any, Nothing, CommentIdType] = ZIO.succeed(commentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest
  ) extends zio.aws.workdocs.model.DeleteCommentRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val commentId: CommentIdType =
      zio.aws.workdocs.model.primitives.CommentIdType(impl.commentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest
  ): zio.aws.workdocs.model.DeleteCommentRequest.ReadOnly = new Wrapper(impl)
}
