package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{PageMarkerType, SizeType}
import scala.jdk.CollectionConverters._
final case class DescribeUsersResponse(
    users: Option[Iterable[zio.aws.workdocs.model.User]] = None,
    totalNumberOfUsers: Option[SizeType] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        totalNumberOfUsers.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.totalNumberOfUsers)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeUsersResponse.wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeUsersResponse =
      zio.aws.workdocs.model.DescribeUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalNumberOfUsers.map(value => value),
        marker.map(value => value)
      )
    def users: Option[List[zio.aws.workdocs.model.User.ReadOnly]]
    def totalNumberOfUsers: Option[SizeType]
    def marker: Option[PageMarkerType]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getTotalNumberOfUsers: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("totalNumberOfUsers", totalNumberOfUsers)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ) extends zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly {
    override val users: Option[List[zio.aws.workdocs.model.User.ReadOnly]] =
      scala
        .Option(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.User.wrap(item)
          }.toList
        )
    override val totalNumberOfUsers: Option[SizeType] = scala
      .Option(impl.totalNumberOfUsers())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ): zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly = new Wrapper(impl)
}
