package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PermissionInfo(
    role: Option[zio.aws.workdocs.model.RoleType] = None,
    `type`: Option[zio.aws.workdocs.model.RolePermissionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.PermissionInfo = {
    import PermissionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.PermissionInfo
      .builder()
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.PermissionInfo.ReadOnly =
    zio.aws.workdocs.model.PermissionInfo.wrap(buildAwsValue())
}
object PermissionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.PermissionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.PermissionInfo =
      zio.aws.workdocs.model
        .PermissionInfo(role.map(value => value), `type`.map(value => value))
    def role: Option[zio.aws.workdocs.model.RoleType]
    def `type`: Option[zio.aws.workdocs.model.RolePermissionType]
    def getRole: ZIO[Any, AwsError, zio.aws.workdocs.model.RoleType] =
      AwsError.unwrapOptionField("role", role)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.RolePermissionType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.PermissionInfo
  ) extends zio.aws.workdocs.model.PermissionInfo.ReadOnly {
    override val role: Option[zio.aws.workdocs.model.RoleType] = scala
      .Option(impl.role())
      .map(value => zio.aws.workdocs.model.RoleType.wrap(value))
    override val `type`: Option[zio.aws.workdocs.model.RolePermissionType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.workdocs.model.RolePermissionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.PermissionInfo
  ): zio.aws.workdocs.model.PermissionInfo.ReadOnly = new Wrapper(impl)
}
