package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{IdType, BooleanType, TimestampType}
import scala.jdk.CollectionConverters._
final case class Activity(
    `type`: Option[zio.aws.workdocs.model.ActivityType] = None,
    timeStamp: Option[TimestampType] = None,
    isIndirectActivity: Option[BooleanType] = None,
    organizationId: Option[IdType] = None,
    initiator: Option[zio.aws.workdocs.model.UserMetadata] = None,
    participants: Option[zio.aws.workdocs.model.Participants] = None,
    resourceMetadata: Option[zio.aws.workdocs.model.ResourceMetadata] = None,
    originalParent: Option[zio.aws.workdocs.model.ResourceMetadata] = None,
    commentMetadata: Option[zio.aws.workdocs.model.CommentMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Activity = {
    import Activity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Activity
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        timeStamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.timeStamp)
      .optionallyWith(
        isIndirectActivity.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.isIndirectActivity)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(participants.map(value => value.buildAwsValue()))(
        _.participants
      )
      .optionallyWith(resourceMetadata.map(value => value.buildAwsValue()))(
        _.resourceMetadata
      )
      .optionallyWith(originalParent.map(value => value.buildAwsValue()))(
        _.originalParent
      )
      .optionallyWith(commentMetadata.map(value => value.buildAwsValue()))(
        _.commentMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Activity.ReadOnly =
    zio.aws.workdocs.model.Activity.wrap(buildAwsValue())
}
object Activity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.Activity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Activity =
      zio.aws.workdocs.model.Activity(
        `type`.map(value => value),
        timeStamp.map(value => value),
        isIndirectActivity.map(value => value),
        organizationId.map(value => value),
        initiator.map(value => value.asEditable),
        participants.map(value => value.asEditable),
        resourceMetadata.map(value => value.asEditable),
        originalParent.map(value => value.asEditable),
        commentMetadata.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.workdocs.model.ActivityType]
    def timeStamp: Option[TimestampType]
    def isIndirectActivity: Option[BooleanType]
    def organizationId: Option[IdType]
    def initiator: Option[zio.aws.workdocs.model.UserMetadata.ReadOnly]
    def participants: Option[zio.aws.workdocs.model.Participants.ReadOnly]
    def resourceMetadata
        : Option[zio.aws.workdocs.model.ResourceMetadata.ReadOnly]
    def originalParent: Option[zio.aws.workdocs.model.ResourceMetadata.ReadOnly]
    def commentMetadata: Option[zio.aws.workdocs.model.CommentMetadata.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.ActivityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTimeStamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("timeStamp", timeStamp)
    def getIsIndirectActivity: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isIndirectActivity", isIndirectActivity)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getInitiator
        : ZIO[Any, AwsError, zio.aws.workdocs.model.UserMetadata.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getParticipants
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Participants.ReadOnly] =
      AwsError.unwrapOptionField("participants", participants)
    def getResourceMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("resourceMetadata", resourceMetadata)
    def getOriginalParent
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("originalParent", originalParent)
    def getCommentMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("commentMetadata", commentMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Activity
  ) extends zio.aws.workdocs.model.Activity.ReadOnly {
    override val `type`: Option[zio.aws.workdocs.model.ActivityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.workdocs.model.ActivityType.wrap(value))
    override val timeStamp: Option[TimestampType] = scala
      .Option(impl.timeStamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val isIndirectActivity: Option[BooleanType] = scala
      .Option(impl.isIndirectActivity())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val initiator
        : Option[zio.aws.workdocs.model.UserMetadata.ReadOnly] = scala
      .Option(impl.initiator())
      .map(value => zio.aws.workdocs.model.UserMetadata.wrap(value))
    override val participants
        : Option[zio.aws.workdocs.model.Participants.ReadOnly] = scala
      .Option(impl.participants())
      .map(value => zio.aws.workdocs.model.Participants.wrap(value))
    override val resourceMetadata
        : Option[zio.aws.workdocs.model.ResourceMetadata.ReadOnly] = scala
      .Option(impl.resourceMetadata())
      .map(value => zio.aws.workdocs.model.ResourceMetadata.wrap(value))
    override val originalParent
        : Option[zio.aws.workdocs.model.ResourceMetadata.ReadOnly] = scala
      .Option(impl.originalParent())
      .map(value => zio.aws.workdocs.model.ResourceMetadata.wrap(value))
    override val commentMetadata
        : Option[zio.aws.workdocs.model.CommentMetadata.ReadOnly] = scala
      .Option(impl.commentMetadata())
      .map(value => zio.aws.workdocs.model.CommentMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Activity
  ): zio.aws.workdocs.model.Activity.ReadOnly = new Wrapper(impl)
}
