package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  AuthenticationHeaderType,
  SharedLabel,
  ResourceIdType
}
import scala.jdk.CollectionConverters._
final case class CreateLabelsRequest(
    resourceId: ResourceIdType,
    labels: Iterable[SharedLabel],
    authenticationToken: Option[AuthenticationHeaderType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest = {
    import CreateLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest
      .builder()
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .labels(labels.map { item =>
        SharedLabel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateLabelsRequest.ReadOnly =
    zio.aws.workdocs.model.CreateLabelsRequest.wrap(buildAwsValue())
}
object CreateLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateLabelsRequest =
      zio.aws.workdocs.model.CreateLabelsRequest(
        resourceId,
        labels,
        authenticationToken.map(value => value)
      )
    def resourceId: ResourceIdType
    def labels: List[SharedLabel]
    def authenticationToken: Option[AuthenticationHeaderType]
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getLabels: ZIO[Any, Nothing, List[SharedLabel]] = ZIO.succeed(labels)
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest
  ) extends zio.aws.workdocs.model.CreateLabelsRequest.ReadOnly {
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val labels: List[SharedLabel] = impl
      .labels()
      .asScala
      .map { item =>
        zio.aws.workdocs.model.primitives.SharedLabel(item)
      }
      .toList
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest
  ): zio.aws.workdocs.model.CreateLabelsRequest.ReadOnly = new Wrapper(impl)
}
