package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait UserStatusType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.UserStatusType
}
object UserStatusType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.UserStatusType
  ): zio.aws.workdocs.model.UserStatusType = value match {
    case software.amazon.awssdk.services.workdocs.model.UserStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.UserStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.workdocs.model.UserStatusType.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.workdocs.model.UserStatusType.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserStatusType =
      software.amazon.awssdk.services.workdocs.model.UserStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.workdocs.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserStatusType =
      software.amazon.awssdk.services.workdocs.model.UserStatusType.ACTIVE
  }
  case object INACTIVE extends zio.aws.workdocs.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserStatusType =
      software.amazon.awssdk.services.workdocs.model.UserStatusType.INACTIVE
  }
  case object PENDING extends zio.aws.workdocs.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserStatusType =
      software.amazon.awssdk.services.workdocs.model.UserStatusType.PENDING
  }
}
