package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeFolderContentsRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    folderId: ResourceIdType,
    sort: Option[zio.aws.workdocs.model.ResourceSortType] = None,
    order: Option[zio.aws.workdocs.model.OrderType] = None,
    limit: Option[LimitType] = None,
    marker: Option[PageMarkerType] = None,
    `type`: Option[zio.aws.workdocs.model.FolderContentType] = None,
    include: Option[FieldNamesType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest = {
    import DescribeFolderContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        include.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.include)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeFolderContentsRequest.wrap(buildAwsValue())
}
object DescribeFolderContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeFolderContentsRequest =
      zio.aws.workdocs.model.DescribeFolderContentsRequest(
        authenticationToken.map(value => value),
        folderId,
        sort.map(value => value),
        order.map(value => value),
        limit.map(value => value),
        marker.map(value => value),
        `type`.map(value => value),
        include.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def sort: Option[zio.aws.workdocs.model.ResourceSortType]
    def order: Option[zio.aws.workdocs.model.OrderType]
    def limit: Option[LimitType]
    def marker: Option[PageMarkerType]
    def `type`: Option[zio.aws.workdocs.model.FolderContentType]
    def include: Option[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
    def getSort: ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceSortType] =
      AwsError.unwrapOptionField("sort", sort)
    def getOrder: ZIO[Any, AwsError, zio.aws.workdocs.model.OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.FolderContentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getInclude: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ) extends zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
    override val sort: Option[zio.aws.workdocs.model.ResourceSortType] = scala
      .Option(impl.sort())
      .map(value => zio.aws.workdocs.model.ResourceSortType.wrap(value))
    override val order: Option[zio.aws.workdocs.model.OrderType] = scala
      .Option(impl.order())
      .map(value => zio.aws.workdocs.model.OrderType.wrap(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val `type`: Option[zio.aws.workdocs.model.FolderContentType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.workdocs.model.FolderContentType.wrap(value))
    override val include: Option[FieldNamesType] = scala
      .Option(impl.include())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ): zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly =
    new Wrapper(impl)
}
