package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters._
final case class DescribeRootFoldersResponse(
    folders: Optional[Iterable[zio.aws.workdocs.model.FolderMetadata]] =
      Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse = {
    import DescribeRootFoldersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse
      .builder()
      .optionallyWith(
        folders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.folders)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeRootFoldersResponse.wrap(buildAwsValue())
}
object DescribeRootFoldersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeRootFoldersResponse =
      zio.aws.workdocs.model.DescribeRootFoldersResponse(
        folders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def folders: Optional[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]]
    def marker: Optional[PageMarkerType]
    def getFolders: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.FolderMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("folders", folders)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse
  ) extends zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly {
    override val folders
        : Optional[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.folders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.FolderMetadata.wrap(item)
          }.toList
        )
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse
  ): zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly = new Wrapper(
    impl
  )
}
