package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.TimestampType
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DateRangeType(
    startValue: Optional[TimestampType] = Optional.Absent,
    endValue: Optional[TimestampType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DateRangeType = {
    import DateRangeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DateRangeType
      .builder()
      .optionallyWith(
        startValue.map(value => TimestampType.unwrap(value): Instant)
      )(_.startValue)
      .optionallyWith(
        endValue.map(value => TimestampType.unwrap(value): Instant)
      )(_.endValue)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DateRangeType.ReadOnly =
    zio.aws.workdocs.model.DateRangeType.wrap(buildAwsValue())
}
object DateRangeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DateRangeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DateRangeType =
      zio.aws.workdocs.model.DateRangeType(
        startValue.map(value => value),
        endValue.map(value => value)
      )
    def startValue: Optional[TimestampType]
    def endValue: Optional[TimestampType]
    def getStartValue: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startValue", startValue)
    def getEndValue: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endValue", endValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DateRangeType
  ) extends zio.aws.workdocs.model.DateRangeType.ReadOnly {
    override val startValue: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.startValue())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val endValue: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.endValue())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DateRangeType
  ): zio.aws.workdocs.model.DateRangeType.ReadOnly = new Wrapper(impl)
}
