package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  IdType,
  UsernameType,
  TimestampType,
  EmailAddressType,
  UserAttributeValueType,
  TimeZoneIdType,
  ResourceIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class User(
    id: Optional[IdType] = Optional.Absent,
    username: Optional[UsernameType] = Optional.Absent,
    emailAddress: Optional[EmailAddressType] = Optional.Absent,
    givenName: Optional[UserAttributeValueType] = Optional.Absent,
    surname: Optional[UserAttributeValueType] = Optional.Absent,
    organizationId: Optional[IdType] = Optional.Absent,
    rootFolderId: Optional[ResourceIdType] = Optional.Absent,
    recycleBinFolderId: Optional[ResourceIdType] = Optional.Absent,
    status: Optional[zio.aws.workdocs.model.UserStatusType] = Optional.Absent,
    `type`: Optional[zio.aws.workdocs.model.UserType] = Optional.Absent,
    createdTimestamp: Optional[TimestampType] = Optional.Absent,
    modifiedTimestamp: Optional[TimestampType] = Optional.Absent,
    timeZoneId: Optional[TimeZoneIdType] = Optional.Absent,
    locale: Optional[zio.aws.workdocs.model.LocaleType] = Optional.Absent,
    storage: Optional[zio.aws.workdocs.model.UserStorageMetadata] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.workdocs.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.User
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        username.map(value => UsernameType.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        emailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .optionallyWith(
        givenName.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.givenName)
      .optionallyWith(
        surname.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.surname)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        rootFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.rootFolderId)
      .optionallyWith(
        recycleBinFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.recycleBinFolderId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(
        timeZoneId.map(value => TimeZoneIdType.unwrap(value): java.lang.String)
      )(_.timeZoneId)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.User.ReadOnly =
    zio.aws.workdocs.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.User = zio.aws.workdocs.model.User(
      id.map(value => value),
      username.map(value => value),
      emailAddress.map(value => value),
      givenName.map(value => value),
      surname.map(value => value),
      organizationId.map(value => value),
      rootFolderId.map(value => value),
      recycleBinFolderId.map(value => value),
      status.map(value => value),
      `type`.map(value => value),
      createdTimestamp.map(value => value),
      modifiedTimestamp.map(value => value),
      timeZoneId.map(value => value),
      locale.map(value => value),
      storage.map(value => value.asEditable)
    )
    def id: Optional[IdType]
    def username: Optional[UsernameType]
    def emailAddress: Optional[EmailAddressType]
    def givenName: Optional[UserAttributeValueType]
    def surname: Optional[UserAttributeValueType]
    def organizationId: Optional[IdType]
    def rootFolderId: Optional[ResourceIdType]
    def recycleBinFolderId: Optional[ResourceIdType]
    def status: Optional[zio.aws.workdocs.model.UserStatusType]
    def `type`: Optional[zio.aws.workdocs.model.UserType]
    def createdTimestamp: Optional[TimestampType]
    def modifiedTimestamp: Optional[TimestampType]
    def timeZoneId: Optional[TimeZoneIdType]
    def locale: Optional[zio.aws.workdocs.model.LocaleType]
    def storage: Optional[zio.aws.workdocs.model.UserStorageMetadata.ReadOnly]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getUsername: ZIO[Any, AwsError, UsernameType] =
      AwsError.unwrapOptionField("username", username)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getGivenName: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getSurname: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("surname", surname)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getRootFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("rootFolderId", rootFolderId)
    def getRecycleBinFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("recycleBinFolderId", recycleBinFolderId)
    def getStatus: ZIO[Any, AwsError, zio.aws.workdocs.model.UserStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getTimeZoneId: ZIO[Any, AwsError, TimeZoneIdType] =
      AwsError.unwrapOptionField("timeZoneId", timeZoneId)
    def getLocale: ZIO[Any, AwsError, zio.aws.workdocs.model.LocaleType] =
      AwsError.unwrapOptionField("locale", locale)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.UserStorageMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.User
  ) extends zio.aws.workdocs.model.User.ReadOnly {
    override val id: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val username: Optional[UsernameType] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.workdocs.model.primitives.UsernameType(value))
    override val emailAddress: Optional[EmailAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailAddress())
        .map(value => zio.aws.workdocs.model.primitives.EmailAddressType(value))
    override val givenName: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.givenName())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val surname: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.surname())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val organizationId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val rootFolderId: Optional[ResourceIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.rootFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val recycleBinFolderId: Optional[ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recycleBinFolderId())
        .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val status: Optional[zio.aws.workdocs.model.UserStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.workdocs.model.UserStatusType.wrap(value))
    override val `type`: Optional[zio.aws.workdocs.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workdocs.model.UserType.wrap(value))
    override val createdTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val timeZoneId: Optional[TimeZoneIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZoneId())
      .map(value => zio.aws.workdocs.model.primitives.TimeZoneIdType(value))
    override val locale: Optional[zio.aws.workdocs.model.LocaleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.workdocs.model.LocaleType.wrap(value))
    override val storage
        : Optional[zio.aws.workdocs.model.UserStorageMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storage())
        .map(value => zio.aws.workdocs.model.UserStorageMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.User
  ): zio.aws.workdocs.model.User.ReadOnly = new Wrapper(impl)
}
