package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.ResponseItemWebUrl
import scala.jdk.CollectionConverters._
final case class ResponseItem(
    resourceType: Optional[zio.aws.workdocs.model.ResponseItemType] =
      Optional.Absent,
    webUrl: Optional[ResponseItemWebUrl] = Optional.Absent,
    documentMetadata: Optional[zio.aws.workdocs.model.DocumentMetadata] =
      Optional.Absent,
    folderMetadata: Optional[zio.aws.workdocs.model.FolderMetadata] =
      Optional.Absent,
    commentMetadata: Optional[zio.aws.workdocs.model.CommentMetadata] =
      Optional.Absent,
    documentVersionMetadata: Optional[
      zio.aws.workdocs.model.DocumentVersionMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ResponseItem = {
    import ResponseItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ResponseItem
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        webUrl.map(value => ResponseItemWebUrl.unwrap(value): java.lang.String)
      )(_.webUrl)
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(folderMetadata.map(value => value.buildAwsValue()))(
        _.folderMetadata
      )
      .optionallyWith(commentMetadata.map(value => value.buildAwsValue()))(
        _.commentMetadata
      )
      .optionallyWith(
        documentVersionMetadata.map(value => value.buildAwsValue())
      )(_.documentVersionMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ResponseItem.ReadOnly =
    zio.aws.workdocs.model.ResponseItem.wrap(buildAwsValue())
}
object ResponseItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ResponseItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ResponseItem =
      zio.aws.workdocs.model.ResponseItem(
        resourceType.map(value => value),
        webUrl.map(value => value),
        documentMetadata.map(value => value.asEditable),
        folderMetadata.map(value => value.asEditable),
        commentMetadata.map(value => value.asEditable),
        documentVersionMetadata.map(value => value.asEditable)
      )
    def resourceType: Optional[zio.aws.workdocs.model.ResponseItemType]
    def webUrl: Optional[ResponseItemWebUrl]
    def documentMetadata
        : Optional[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]
    def folderMetadata: Optional[zio.aws.workdocs.model.FolderMetadata.ReadOnly]
    def commentMetadata
        : Optional[zio.aws.workdocs.model.CommentMetadata.ReadOnly]
    def documentVersionMetadata
        : Optional[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResponseItemType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getWebUrl: ZIO[Any, AwsError, ResponseItemWebUrl] =
      AwsError.unwrapOptionField("webUrl", webUrl)
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getFolderMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      AwsError.unwrapOptionField("folderMetadata", folderMetadata)
    def getCommentMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("commentMetadata", commentMetadata)
    def getDocumentVersionMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentVersionMetadata",
      documentVersionMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ResponseItem
  ) extends zio.aws.workdocs.model.ResponseItem.ReadOnly {
    override val resourceType
        : Optional[zio.aws.workdocs.model.ResponseItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.workdocs.model.ResponseItemType.wrap(value))
    override val webUrl: Optional[ResponseItemWebUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.webUrl())
      .map(value => zio.aws.workdocs.model.primitives.ResponseItemWebUrl(value))
    override val documentMetadata
        : Optional[zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.workdocs.model.DocumentMetadata.wrap(value))
    override val folderMetadata
        : Optional[zio.aws.workdocs.model.FolderMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.folderMetadata())
        .map(value => zio.aws.workdocs.model.FolderMetadata.wrap(value))
    override val commentMetadata
        : Optional[zio.aws.workdocs.model.CommentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commentMetadata())
        .map(value => zio.aws.workdocs.model.CommentMetadata.wrap(value))
    override val documentVersionMetadata
        : Optional[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersionMetadata())
        .map(value =>
          zio.aws.workdocs.model.DocumentVersionMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ResponseItem
  ): zio.aws.workdocs.model.ResponseItem.ReadOnly = new Wrapper(impl)
}
