package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait ResourceCollectionType {
  def unwrap
      : software.amazon.awssdk.services.workdocs.model.ResourceCollectionType
}
object ResourceCollectionType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ResourceCollectionType
  ): zio.aws.workdocs.model.ResourceCollectionType = value match {
    case software.amazon.awssdk.services.workdocs.model.ResourceCollectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceCollectionType.SHARED_WITH_ME =>
      val r = SHARED_WITH_ME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceCollectionType =
      software.amazon.awssdk.services.workdocs.model.ResourceCollectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SHARED_WITH_ME
      extends zio.aws.workdocs.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceCollectionType =
      software.amazon.awssdk.services.workdocs.model.ResourceCollectionType.SHARED_WITH_ME
  }
}
