package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait FolderContentType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.FolderContentType
}
object FolderContentType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.FolderContentType
  ): zio.aws.workdocs.model.FolderContentType = value match {
    case software.amazon.awssdk.services.workdocs.model.FolderContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.FolderContentType.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.workdocs.model.FolderContentType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.workdocs.model.FolderContentType.FOLDER =>
      val r = FOLDER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.FolderContentType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.FolderContentType =
      software.amazon.awssdk.services.workdocs.model.FolderContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.workdocs.model.FolderContentType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.FolderContentType =
      software.amazon.awssdk.services.workdocs.model.FolderContentType.ALL
  }
  case object DOCUMENT extends zio.aws.workdocs.model.FolderContentType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.FolderContentType =
      software.amazon.awssdk.services.workdocs.model.FolderContentType.DOCUMENT
  }
  case object FOLDER extends zio.aws.workdocs.model.FolderContentType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.FolderContentType =
      software.amazon.awssdk.services.workdocs.model.FolderContentType.FOLDER
  }
}
