package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.PrincipalType
  ): zio.aws.workdocs.model.PrincipalType = value match {
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.GROUP =>
      val r = GROUP
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.INVITE =>
      val r = INVITE
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.ANONYMOUS =>
      val r = ANONYMOUS
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalType.ORGANIZATION =>
      val r = ORGANIZATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.USER
  }
  case object GROUP extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.GROUP
  }
  case object INVITE extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.INVITE
  }
  case object ANONYMOUS extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.ANONYMOUS
  }
  case object ORGANIZATION extends zio.aws.workdocs.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalType =
      software.amazon.awssdk.services.workdocs.model.PrincipalType.ORGANIZATION
  }
}
