package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  TimeZoneIdType,
  UserAttributeValueType,
  IdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class UpdateUserRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    userId: IdType,
    givenName: Optional[UserAttributeValueType] = Optional.Absent,
    surname: Optional[UserAttributeValueType] = Optional.Absent,
    `type`: Optional[zio.aws.workdocs.model.UserType] = Optional.Absent,
    storageRule: Optional[zio.aws.workdocs.model.StorageRuleType] =
      Optional.Absent,
    timeZoneId: Optional[TimeZoneIdType] = Optional.Absent,
    locale: Optional[zio.aws.workdocs.model.LocaleType] = Optional.Absent,
    grantPoweruserPrivileges: Optional[zio.aws.workdocs.model.BooleanEnumType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateUserRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .userId(IdType.unwrap(userId): java.lang.String)
      .optionallyWith(
        givenName.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.givenName)
      .optionallyWith(
        surname.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.surname)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(storageRule.map(value => value.buildAwsValue()))(
        _.storageRule
      )
      .optionallyWith(
        timeZoneId.map(value => TimeZoneIdType.unwrap(value): java.lang.String)
      )(_.timeZoneId)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(grantPoweruserPrivileges.map(value => value.unwrap))(
        _.grantPoweruserPrivileges
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateUserRequest.ReadOnly =
    zio.aws.workdocs.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateUserRequest =
      zio.aws.workdocs.model.UpdateUserRequest(
        authenticationToken.map(value => value),
        userId,
        givenName.map(value => value),
        surname.map(value => value),
        `type`.map(value => value),
        storageRule.map(value => value.asEditable),
        timeZoneId.map(value => value),
        locale.map(value => value),
        grantPoweruserPrivileges.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def userId: IdType
    def givenName: Optional[UserAttributeValueType]
    def surname: Optional[UserAttributeValueType]
    def `type`: Optional[zio.aws.workdocs.model.UserType]
    def storageRule: Optional[zio.aws.workdocs.model.StorageRuleType.ReadOnly]
    def timeZoneId: Optional[TimeZoneIdType]
    def locale: Optional[zio.aws.workdocs.model.LocaleType]
    def grantPoweruserPrivileges
        : Optional[zio.aws.workdocs.model.BooleanEnumType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getUserId: ZIO[Any, Nothing, IdType] = ZIO.succeed(userId)
    def getGivenName: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getSurname: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("surname", surname)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStorageRule
        : ZIO[Any, AwsError, zio.aws.workdocs.model.StorageRuleType.ReadOnly] =
      AwsError.unwrapOptionField("storageRule", storageRule)
    def getTimeZoneId: ZIO[Any, AwsError, TimeZoneIdType] =
      AwsError.unwrapOptionField("timeZoneId", timeZoneId)
    def getLocale: ZIO[Any, AwsError, zio.aws.workdocs.model.LocaleType] =
      AwsError.unwrapOptionField("locale", locale)
    def getGrantPoweruserPrivileges
        : ZIO[Any, AwsError, zio.aws.workdocs.model.BooleanEnumType] = AwsError
      .unwrapOptionField("grantPoweruserPrivileges", grantPoweruserPrivileges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateUserRequest
  ) extends zio.aws.workdocs.model.UpdateUserRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val userId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.userId())
    override val givenName: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.givenName())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val surname: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.surname())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val `type`: Optional[zio.aws.workdocs.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workdocs.model.UserType.wrap(value))
    override val storageRule
        : Optional[zio.aws.workdocs.model.StorageRuleType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageRule())
        .map(value => zio.aws.workdocs.model.StorageRuleType.wrap(value))
    override val timeZoneId: Optional[TimeZoneIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZoneId())
      .map(value => zio.aws.workdocs.model.primitives.TimeZoneIdType(value))
    override val locale: Optional[zio.aws.workdocs.model.LocaleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.workdocs.model.LocaleType.wrap(value))
    override val grantPoweruserPrivileges
        : Optional[zio.aws.workdocs.model.BooleanEnumType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantPoweruserPrivileges())
        .map(value => zio.aws.workdocs.model.BooleanEnumType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateUserRequest
  ): zio.aws.workdocs.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
