package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class GetDocumentRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    includeCustomMetadata: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentRequest = {
    import GetDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .optionallyWith(
        includeCustomMetadata.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeCustomMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentRequest.ReadOnly =
    zio.aws.workdocs.model.GetDocumentRequest.wrap(buildAwsValue())
}
object GetDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentRequest =
      zio.aws.workdocs.model.GetDocumentRequest(
        authenticationToken.map(value => value),
        documentId,
        includeCustomMetadata.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def includeCustomMetadata: Option[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getIncludeCustomMetadata: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("includeCustomMetadata", includeCustomMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentRequest
  ) extends zio.aws.workdocs.model.GetDocumentRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val includeCustomMetadata: Option[BooleanType] = scala
      .Option(impl.includeCustomMetadata())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentRequest
  ): zio.aws.workdocs.model.GetDocumentRequest.ReadOnly = new Wrapper(impl)
}
