package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  CustomMetadataValueType,
  CustomMetadataKeyType
}
import scala.jdk.CollectionConverters._
final case class GetDocumentResponse(
    metadata: Option[zio.aws.workdocs.model.DocumentMetadata] = None,
    customMetadata: Option[
      Map[CustomMetadataKeyType, CustomMetadataValueType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentResponse = {
    import GetDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        customMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (CustomMetadataKeyType
                .unwrap(key): java.lang.String) -> (CustomMetadataValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentResponse.ReadOnly =
    zio.aws.workdocs.model.GetDocumentResponse.wrap(buildAwsValue())
}
object GetDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentResponse =
      zio.aws.workdocs.model.GetDocumentResponse(
        metadata.map(value => value.asEditable),
        customMetadata.map(value => value)
      )
    def metadata: Option[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]
    def customMetadata
        : Option[Map[CustomMetadataKeyType, CustomMetadataValueType]]
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getCustomMetadata: ZIO[Any, AwsError, Map[
      CustomMetadataKeyType,
      CustomMetadataValueType
    ]] = AwsError.unwrapOptionField("customMetadata", customMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentResponse
  ) extends zio.aws.workdocs.model.GetDocumentResponse.ReadOnly {
    override val metadata
        : Option[zio.aws.workdocs.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.workdocs.model.DocumentMetadata.wrap(value))
    override val customMetadata
        : Option[Map[CustomMetadataKeyType, CustomMetadataValueType]] = scala
      .Option(impl.customMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.workdocs.model.primitives
              .CustomMetadataKeyType(key) -> zio.aws.workdocs.model.primitives
              .CustomMetadataValueType(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentResponse
  ): zio.aws.workdocs.model.GetDocumentResponse.ReadOnly = new Wrapper(impl)
}
