package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  IdType,
  UsernameType,
  TimestampType,
  EmailAddressType,
  UserAttributeValueType,
  TimeZoneIdType,
  ResourceIdType
}
import scala.jdk.CollectionConverters._
final case class User(
    id: Option[IdType] = None,
    username: Option[UsernameType] = None,
    emailAddress: Option[EmailAddressType] = None,
    givenName: Option[UserAttributeValueType] = None,
    surname: Option[UserAttributeValueType] = None,
    organizationId: Option[IdType] = None,
    rootFolderId: Option[ResourceIdType] = None,
    recycleBinFolderId: Option[ResourceIdType] = None,
    status: Option[zio.aws.workdocs.model.UserStatusType] = None,
    `type`: Option[zio.aws.workdocs.model.UserType] = None,
    createdTimestamp: Option[TimestampType] = None,
    modifiedTimestamp: Option[TimestampType] = None,
    timeZoneId: Option[TimeZoneIdType] = None,
    locale: Option[zio.aws.workdocs.model.LocaleType] = None,
    storage: Option[zio.aws.workdocs.model.UserStorageMetadata] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.workdocs.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.User
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        username.map(value => UsernameType.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        emailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .optionallyWith(
        givenName.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.givenName)
      .optionallyWith(
        surname.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.surname)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        rootFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.rootFolderId)
      .optionallyWith(
        recycleBinFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.recycleBinFolderId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(
        timeZoneId.map(value => TimeZoneIdType.unwrap(value): java.lang.String)
      )(_.timeZoneId)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.User.ReadOnly =
    zio.aws.workdocs.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.User = zio.aws.workdocs.model.User(
      id.map(value => value),
      username.map(value => value),
      emailAddress.map(value => value),
      givenName.map(value => value),
      surname.map(value => value),
      organizationId.map(value => value),
      rootFolderId.map(value => value),
      recycleBinFolderId.map(value => value),
      status.map(value => value),
      `type`.map(value => value),
      createdTimestamp.map(value => value),
      modifiedTimestamp.map(value => value),
      timeZoneId.map(value => value),
      locale.map(value => value),
      storage.map(value => value.asEditable)
    )
    def id: Option[IdType]
    def username: Option[UsernameType]
    def emailAddress: Option[EmailAddressType]
    def givenName: Option[UserAttributeValueType]
    def surname: Option[UserAttributeValueType]
    def organizationId: Option[IdType]
    def rootFolderId: Option[ResourceIdType]
    def recycleBinFolderId: Option[ResourceIdType]
    def status: Option[zio.aws.workdocs.model.UserStatusType]
    def `type`: Option[zio.aws.workdocs.model.UserType]
    def createdTimestamp: Option[TimestampType]
    def modifiedTimestamp: Option[TimestampType]
    def timeZoneId: Option[TimeZoneIdType]
    def locale: Option[zio.aws.workdocs.model.LocaleType]
    def storage: Option[zio.aws.workdocs.model.UserStorageMetadata.ReadOnly]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getUsername: ZIO[Any, AwsError, UsernameType] =
      AwsError.unwrapOptionField("username", username)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getGivenName: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getSurname: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("surname", surname)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getRootFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("rootFolderId", rootFolderId)
    def getRecycleBinFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("recycleBinFolderId", recycleBinFolderId)
    def getStatus: ZIO[Any, AwsError, zio.aws.workdocs.model.UserStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getTimeZoneId: ZIO[Any, AwsError, TimeZoneIdType] =
      AwsError.unwrapOptionField("timeZoneId", timeZoneId)
    def getLocale: ZIO[Any, AwsError, zio.aws.workdocs.model.LocaleType] =
      AwsError.unwrapOptionField("locale", locale)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.UserStorageMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.User
  ) extends zio.aws.workdocs.model.User.ReadOnly {
    override val id: Option[IdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val username: Option[UsernameType] = scala
      .Option(impl.username())
      .map(value => zio.aws.workdocs.model.primitives.UsernameType(value))
    override val emailAddress: Option[EmailAddressType] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.workdocs.model.primitives.EmailAddressType(value))
    override val givenName: Option[UserAttributeValueType] = scala
      .Option(impl.givenName())
      .map(value =>
        zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
      )
    override val surname: Option[UserAttributeValueType] = scala
      .Option(impl.surname())
      .map(value =>
        zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
      )
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val rootFolderId: Option[ResourceIdType] = scala
      .Option(impl.rootFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val recycleBinFolderId: Option[ResourceIdType] = scala
      .Option(impl.recycleBinFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val status: Option[zio.aws.workdocs.model.UserStatusType] = scala
      .Option(impl.status())
      .map(value => zio.aws.workdocs.model.UserStatusType.wrap(value))
    override val `type`: Option[zio.aws.workdocs.model.UserType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.workdocs.model.UserType.wrap(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.modifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val timeZoneId: Option[TimeZoneIdType] = scala
      .Option(impl.timeZoneId())
      .map(value => zio.aws.workdocs.model.primitives.TimeZoneIdType(value))
    override val locale: Option[zio.aws.workdocs.model.LocaleType] = scala
      .Option(impl.locale())
      .map(value => zio.aws.workdocs.model.LocaleType.wrap(value))
    override val storage
        : Option[zio.aws.workdocs.model.UserStorageMetadata.ReadOnly] = scala
      .Option(impl.storage())
      .map(value => zio.aws.workdocs.model.UserStorageMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.User
  ): zio.aws.workdocs.model.User.ReadOnly = new Wrapper(impl)
}
