package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{ResourceNameType, IdType}
import scala.jdk.CollectionConverters._
final case class ResourcePathComponent(
    id: Option[IdType] = None,
    name: Option[ResourceNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ResourcePathComponent = {
    import ResourcePathComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ResourcePathComponent
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ResourcePathComponent.ReadOnly =
    zio.aws.workdocs.model.ResourcePathComponent.wrap(buildAwsValue())
}
object ResourcePathComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ResourcePathComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ResourcePathComponent =
      zio.aws.workdocs.model
        .ResourcePathComponent(id.map(value => value), name.map(value => value))
    def id: Option[IdType]
    def name: Option[ResourceNameType]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ResourcePathComponent
  ) extends zio.aws.workdocs.model.ResourcePathComponent.ReadOnly {
    override val id: Option[IdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ResourcePathComponent
  ): zio.aws.workdocs.model.ResourcePathComponent.ReadOnly = new Wrapper(impl)
}
