package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{MessageType, BooleanType}
import scala.jdk.CollectionConverters._
final case class NotificationOptions(
    sendEmail: Option[BooleanType] = None,
    emailMessage: Option[MessageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.NotificationOptions = {
    import NotificationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.NotificationOptions
      .builder()
      .optionallyWith(
        sendEmail.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.sendEmail)
      .optionallyWith(
        emailMessage.map(value => MessageType.unwrap(value): java.lang.String)
      )(_.emailMessage)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.NotificationOptions.ReadOnly =
    zio.aws.workdocs.model.NotificationOptions.wrap(buildAwsValue())
}
object NotificationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.NotificationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.NotificationOptions =
      zio.aws.workdocs.model.NotificationOptions(
        sendEmail.map(value => value),
        emailMessage.map(value => value)
      )
    def sendEmail: Option[BooleanType]
    def emailMessage: Option[MessageType]
    def getSendEmail: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("sendEmail", sendEmail)
    def getEmailMessage: ZIO[Any, AwsError, MessageType] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.NotificationOptions
  ) extends zio.aws.workdocs.model.NotificationOptions.ReadOnly {
    override val sendEmail: Option[BooleanType] = scala
      .Option(impl.sendEmail())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
    override val emailMessage: Option[MessageType] = scala
      .Option(impl.emailMessage())
      .map(value => zio.aws.workdocs.model.primitives.MessageType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.NotificationOptions
  ): zio.aws.workdocs.model.NotificationOptions.ReadOnly = new Wrapper(impl)
}
