package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait OrderType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.OrderType
}
object OrderType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.OrderType
  ): zio.aws.workdocs.model.OrderType = value match {
    case software.amazon.awssdk.services.workdocs.model.OrderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.OrderType.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.workdocs.model.OrderType.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.OrderType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.OrderType =
      software.amazon.awssdk.services.workdocs.model.OrderType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.workdocs.model.OrderType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.OrderType =
      software.amazon.awssdk.services.workdocs.model.OrderType.ASCENDING
  }
  case object DESCENDING extends zio.aws.workdocs.model.OrderType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.OrderType =
      software.amazon.awssdk.services.workdocs.model.OrderType.DESCENDING
  }
}
