package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNotificationSubscriptionResponse(
    subscription: Option[zio.aws.workdocs.model.Subscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse = {
    import CreateNotificationSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse
      .builder()
      .optionallyWith(subscription.map(value => value.buildAwsValue()))(
        _.subscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly =
    zio.aws.workdocs.model.CreateNotificationSubscriptionResponse
      .wrap(buildAwsValue())
}
object CreateNotificationSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.CreateNotificationSubscriptionResponse =
      zio.aws.workdocs.model.CreateNotificationSubscriptionResponse(
        subscription.map(value => value.asEditable)
      )
    def subscription: Option[zio.aws.workdocs.model.Subscription.ReadOnly]
    def getSubscription
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Subscription.ReadOnly] =
      AwsError.unwrapOptionField("subscription", subscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse
  ) extends zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly {
    override val subscription
        : Option[zio.aws.workdocs.model.Subscription.ReadOnly] = scala
      .Option(impl.subscription())
      .map(value => zio.aws.workdocs.model.Subscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse
  ): zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
