package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDocumentPathResponse(
    path: Option[zio.aws.workdocs.model.ResourcePath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse = {
    import GetDocumentPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse
      .builder()
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly =
    zio.aws.workdocs.model.GetDocumentPathResponse.wrap(buildAwsValue())
}
object GetDocumentPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentPathResponse =
      zio.aws.workdocs.model
        .GetDocumentPathResponse(path.map(value => value.asEditable))
    def path: Option[zio.aws.workdocs.model.ResourcePath.ReadOnly]
    def getPath
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourcePath.ReadOnly] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse
  ) extends zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly {
    override val path: Option[zio.aws.workdocs.model.ResourcePath.ReadOnly] =
      scala
        .Option(impl.path())
        .map(value => zio.aws.workdocs.model.ResourcePath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse
  ): zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly = new Wrapper(impl)
}
