package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCommentResponse(
    comment: Option[zio.aws.workdocs.model.Comment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateCommentResponse = {
    import CreateCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateCommentResponse.ReadOnly =
    zio.aws.workdocs.model.CreateCommentResponse.wrap(buildAwsValue())
}
object CreateCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateCommentResponse =
      zio.aws.workdocs.model
        .CreateCommentResponse(comment.map(value => value.asEditable))
    def comment: Option[zio.aws.workdocs.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ) extends zio.aws.workdocs.model.CreateCommentResponse.ReadOnly {
    override val comment: Option[zio.aws.workdocs.model.Comment.ReadOnly] =
      scala
        .Option(impl.comment())
        .map(value => zio.aws.workdocs.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ): zio.aws.workdocs.model.CreateCommentResponse.ReadOnly = new Wrapper(impl)
}
