package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourcePath(
    components: Option[Iterable[zio.aws.workdocs.model.ResourcePathComponent]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ResourcePath = {
    import ResourcePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ResourcePath
      .builder()
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ResourcePath.ReadOnly =
    zio.aws.workdocs.model.ResourcePath.wrap(buildAwsValue())
}
object ResourcePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ResourcePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ResourcePath =
      zio.aws.workdocs.model.ResourcePath(
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def components
        : Option[List[zio.aws.workdocs.model.ResourcePathComponent.ReadOnly]]
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.ResourcePathComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ResourcePath
  ) extends zio.aws.workdocs.model.ResourcePath.ReadOnly {
    override val components
        : Option[List[zio.aws.workdocs.model.ResourcePathComponent.ReadOnly]] =
      scala
        .Option(impl.components())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.ResourcePathComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ResourcePath
  ): zio.aws.workdocs.model.ResourcePath.ReadOnly = new Wrapper(impl)
}
