package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  DocumentVersionIdType,
  ResourceIdType,
  ResourceNameType
}
import scala.jdk.CollectionConverters._
final case class ResourceMetadata(
    `type`: Option[zio.aws.workdocs.model.ResourceType] = None,
    name: Option[ResourceNameType] = None,
    originalName: Option[ResourceNameType] = None,
    id: Option[ResourceIdType] = None,
    versionId: Option[DocumentVersionIdType] = None,
    owner: Option[zio.aws.workdocs.model.UserMetadata] = None,
    parentId: Option[ResourceIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ResourceMetadata = {
    import ResourceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ResourceMetadata
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        originalName.map(value =>
          ResourceNameType.unwrap(value): java.lang.String
        )
      )(_.originalName)
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        versionId.map(value =>
          DocumentVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        parentId.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.parentId)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ResourceMetadata.ReadOnly =
    zio.aws.workdocs.model.ResourceMetadata.wrap(buildAwsValue())
}
object ResourceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ResourceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ResourceMetadata =
      zio.aws.workdocs.model.ResourceMetadata(
        `type`.map(value => value),
        name.map(value => value),
        originalName.map(value => value),
        id.map(value => value),
        versionId.map(value => value),
        owner.map(value => value.asEditable),
        parentId.map(value => value)
      )
    def `type`: Option[zio.aws.workdocs.model.ResourceType]
    def name: Option[ResourceNameType]
    def originalName: Option[ResourceNameType]
    def id: Option[ResourceIdType]
    def versionId: Option[DocumentVersionIdType]
    def owner: Option[zio.aws.workdocs.model.UserMetadata.ReadOnly]
    def parentId: Option[ResourceIdType]
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getOriginalName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("originalName", originalName)
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getVersionId: ZIO[Any, AwsError, DocumentVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.workdocs.model.UserMetadata.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getParentId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentId", parentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ResourceMetadata
  ) extends zio.aws.workdocs.model.ResourceMetadata.ReadOnly {
    override val `type`: Option[zio.aws.workdocs.model.ResourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.workdocs.model.ResourceType.wrap(value))
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val originalName: Option[ResourceNameType] = scala
      .Option(impl.originalName())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val id: Option[ResourceIdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val versionId: Option[DocumentVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentVersionIdType(value)
      )
    override val owner: Option[zio.aws.workdocs.model.UserMetadata.ReadOnly] =
      scala
        .Option(impl.owner())
        .map(value => zio.aws.workdocs.model.UserMetadata.wrap(value))
    override val parentId: Option[ResourceIdType] = scala
      .Option(impl.parentId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ResourceMetadata
  ): zio.aws.workdocs.model.ResourceMetadata.ReadOnly = new Wrapper(impl)
}
